/*
 * Decompiled with CFR 0.152.
 */
package org.languagetool.language;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.ResourceBundle;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.languagetool.GlobalConfig;
import org.languagetool.Language;
import org.languagetool.Languages;
import org.languagetool.UserConfig;
import org.languagetool.language.English;
import org.languagetool.languagemodel.LanguageModel;
import org.languagetool.rules.Rule;
import org.languagetool.rules.en.MorfologikCanadianSpellerRule;
import org.languagetool.rules.en.UnitConversionRuleImperial;
import org.languagetool.rules.spelling.SpellingCheckRule;

public class CanadianEnglish
extends English {
    private static final String LANGUAGE_SHORT_CODE = "en-CA";
    private static volatile Throwable instantiationTrace;

    public CanadianEnglish() {
        Throwable trace = instantiationTrace;
        if (trace != null) {
            throw new RuntimeException("Language was already instantiated, see the cause stacktrace below.", trace);
        }
        instantiationTrace = new Throwable();
    }

    protected CanadianEnglish(boolean fakeValue) {
    }

    @Override
    public String[] getCountries() {
        return new String[]{"CA"};
    }

    @Override
    public String getName() {
        return "English (Canadian)";
    }

    @Override
    public SpellingCheckRule createDefaultSpellingRule(ResourceBundle messages) throws IOException {
        return new MorfologikCanadianSpellerRule(messages, (Language)this, null, Collections.emptyList());
    }

    @Override
    public List<Rule> getRelevantRules(ResourceBundle messages, UserConfig userConfig, Language motherTongue, List<Language> altLanguages) throws IOException {
        ArrayList<Rule> rules = new ArrayList<Rule>();
        rules.addAll(super.getRelevantRules(messages, userConfig, motherTongue, altLanguages));
        rules.add((Rule)new UnitConversionRuleImperial(messages));
        return rules;
    }

    @Override
    public List<Rule> getRelevantLanguageModelCapableRules(ResourceBundle messages, @Nullable LanguageModel lm, GlobalConfig globalConfig, UserConfig userConfig, Language motherTongue, List<Language> altLanguages) throws IOException {
        ArrayList<Rule> rules = new ArrayList<Rule>(super.getRelevantLanguageModelCapableRules(messages, lm, globalConfig, userConfig, motherTongue, altLanguages));
        rules.add((Rule)new MorfologikCanadianSpellerRule(messages, (Language)this, globalConfig, userConfig, altLanguages, lm, motherTongue));
        return rules;
    }

    @NotNull
    public static English getInstance() {
        Language language = Objects.requireNonNull(Languages.getLanguageForShortCode((String)LANGUAGE_SHORT_CODE));
        if (language instanceof English) {
            English canadianEnglish = (English)language;
            return canadianEnglish;
        }
        throw new RuntimeException("CanadianEnglish language expected, got " + language);
    }
}

