/*
 * Decompiled with CFR 0.152.
 */
package help.validator.links;

import help.validator.links.InvalidLink;
import help.validator.model.IMG;
import java.nio.file.Path;

public class InvalidIMGLink
implements InvalidLink {
    protected final IMG img;
    protected final String message;

    protected InvalidIMGLink(IMG img, String message) {
        this.img = img;
        this.message = message;
        if (Boolean.parseBoolean(System.getProperty("ghidra.help.failfast"))) {
            throw new RuntimeException(message + ": " + String.valueOf(img));
        }
    }

    public IMG getIMG() {
        return this.img;
    }

    @Override
    public int identityHashCode() {
        return System.identityHashCode(this.img);
    }

    @Override
    public int getLineNumber() {
        return this.img.getLineNumber();
    }

    @Override
    public Path getSourceFile() {
        return this.img.getSourceFile();
    }

    @Override
    public int compareTo(InvalidLink other) {
        String otherClassName;
        if (other == null) {
            return 1;
        }
        if (!(other instanceof InvalidIMGLink)) {
            return 1;
        }
        InvalidIMGLink otherLink = (InvalidIMGLink)other;
        String className = this.getClass().getSimpleName();
        int result = className.compareTo(otherClassName = other.getClass().getSimpleName());
        if (result != 0) {
            return -result;
        }
        return this.img.compareTo(otherLink.img);
    }

    @Override
    public String toString() {
        return this.message + " -\n\tlink: " + String.valueOf(this.img) + "\n\tfrom file: " + this.getSourceFileInfo();
    }

    private String getSourceFileInfo() {
        int lineNumber = this.img.getLineNumber();
        return String.valueOf(this.img.getSourceFile().toUri()) + " (line:" + lineNumber + ")";
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.img == null ? 0 : this.img.hashCode());
        result = 31 * result + (this.message == null ? 0 : this.message.hashCode());
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        InvalidIMGLink other = (InvalidIMGLink)obj;
        if (this.img == null ? other.img != null : !this.img.equals(other.img)) {
            return false;
        }
        return !(this.message == null ? other.message != null : !this.message.equals(other.message));
    }
}

