/*
 * Decompiled with CFR 0.152.
 */
package ghidra.util.table.field;

import ghidra.docking.settings.BooleanSettingsDefinition;
import ghidra.docking.settings.Settings;

public class FunctionThunkSettingsDefinition
implements BooleanSettingsDefinition {
    public static final FunctionThunkSettingsDefinition DEF = new FunctionThunkSettingsDefinition();
    private static final String THUNK = "Show thunk";
    private static final String NAME = "Show thunk";
    private static final String DESCRIPTION = "On siganls to show the thunk function attribute when present";
    private static final boolean DEFAULT = true;

    public boolean getValue(Settings settings) {
        if (settings == null) {
            return true;
        }
        String value = settings.getString("Show thunk");
        if (value == null) {
            return true;
        }
        return Boolean.parseBoolean(value);
    }

    public String getValueString(Settings settings) {
        return Boolean.toString(this.getValue(settings));
    }

    public void setValue(Settings settings, boolean value) {
        settings.setString("Show thunk", Boolean.toString(value));
    }

    public void copySetting(Settings srcSettings, Settings destSettings) {
        String value = srcSettings.getString("Show thunk");
        if (value == null) {
            destSettings.clearSetting("Show thunk");
        } else {
            destSettings.setString("Show thunk", value);
        }
    }

    public void clear(Settings settings) {
        settings.clearSetting("Show thunk");
    }

    public String getDescription() {
        return DESCRIPTION;
    }

    public String getName() {
        return "Show thunk";
    }

    public String getStorageKey() {
        return "Show thunk";
    }

    public boolean hasValue(Settings settings) {
        return settings.getValue("Show thunk") != null;
    }
}

