/*
 * Decompiled with CFR 0.152.
 */
package ghidra.features.base.values;

import docking.Tool;
import ghidra.app.services.ProgramManager;
import ghidra.features.base.values.ProjectFileValue;
import ghidra.framework.main.AppInfo;
import ghidra.framework.model.DomainFile;
import ghidra.framework.model.Project;
import ghidra.program.model.listing.Program;
import ghidra.util.SystemUtilities;
import ghidra.util.VersionExceptionHandler;
import ghidra.util.exception.CancelledException;
import ghidra.util.exception.VersionException;
import ghidra.util.task.TaskMonitor;
import java.io.IOException;

public class ProgramFileValue
extends ProjectFileValue {
    public ProgramFileValue(String name) {
        this(name, (String)null);
    }

    public ProgramFileValue(String name, String startingPath) {
        this(name, AppInfo.getActiveProject(), startingPath);
    }

    public ProgramFileValue(String name, Project project, String startingPath) {
        super(name, project, startingPath, Program.class);
    }

    public Program openProgram(Object consumer, Tool tool, boolean upgradeIfNeeded, TaskMonitor monitor) throws VersionException, IOException, CancelledException {
        DomainFile domainFile = (DomainFile)this.getValue();
        if (domainFile == null) {
            return null;
        }
        Program program = this.doOpenProgram(domainFile, consumer, upgradeIfNeeded, monitor);
        if (tool != null && program != null) {
            ((ProgramManager)tool.getService(ProgramManager.class)).openProgram(program);
        }
        return program;
    }

    private Program doOpenProgram(DomainFile domainFile, Object consumer, boolean upgradeIfNeeded, TaskMonitor monitor) throws VersionException, IOException, CancelledException {
        try {
            return (Program)domainFile.getDomainObject(consumer, upgradeIfNeeded, false, monitor);
        }
        catch (VersionException e) {
            if (SystemUtilities.isInHeadlessMode()) {
                throw e;
            }
            if (VersionExceptionHandler.isUpgradeOK(null, (DomainFile)domainFile, (String)"Open ", (VersionException)e)) {
                return (Program)domainFile.getDomainObject(consumer, true, false, monitor);
            }
            throw e;
        }
    }
}

