/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.util.bin.format.omf.omf51;

import ghidra.app.util.bin.BinaryReader;
import java.io.IOException;

public class Omf51Fixup {
    public static final int REF_TYPE_LOW = 0;
    public static final int REF_TYPE_BYTE = 1;
    public static final int REF_TYPE_RELATIVE = 2;
    public static final int REF_TYPE_HIGH = 3;
    public static final int REF_TYPE_WORD = 4;
    public static final int REF_TYPE_INBLOCK = 5;
    public static final int REF_TYPE_BIT = 6;
    public static final int REF_TYPE_CONV = 7;
    public static final int ID_BLOCK_SEGMENT = 0;
    public static final int ID_BLOCK_RELOCATABLE = 1;
    public static final int ID_BLOCK_EXTERNAL = 2;
    private int refLoc;
    private byte refType;
    private byte blockType;
    private int blockId;
    private int offset;

    public Omf51Fixup(BinaryReader reader, boolean largeBlockId) throws IOException {
        this.refLoc = reader.readNextUnsignedShort();
        this.refType = reader.readNextByte();
        this.blockType = reader.readNextByte();
        this.blockId = largeBlockId ? reader.readNextUnsignedShort() : reader.readNextUnsignedByte();
        this.offset = reader.readNextUnsignedShort();
    }

    public int getRefLoc() {
        return this.refLoc;
    }

    public int getRefType() {
        return this.refType;
    }

    public int getBlockType() {
        return this.blockType;
    }

    public int getBlockId() {
        return this.blockId;
    }

    public int getOffset() {
        return this.offset;
    }
}

