/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.core.help;

import docking.ActionContext;
import docking.action.DockingAction;
import docking.action.DockingActionIf;
import docking.action.MenuData;
import ghidra.app.context.ProgramActionContext;
import ghidra.app.context.ProgramContextAction;
import ghidra.app.plugin.core.help.AboutDomainObjectUtils;
import ghidra.framework.main.ApplicationLevelPlugin;
import ghidra.framework.main.FrontEndTool;
import ghidra.framework.main.datatable.FrontendProjectTreeAction;
import ghidra.framework.main.datatable.ProjectDataContext;
import ghidra.framework.model.DomainFile;
import ghidra.framework.plugintool.Plugin;
import ghidra.framework.plugintool.PluginInfo;
import ghidra.framework.plugintool.PluginTool;
import ghidra.framework.plugintool.util.PluginStatus;
import ghidra.program.model.lang.CompilerSpec;
import ghidra.program.model.lang.CompilerSpecID;
import ghidra.program.model.lang.CompilerSpecNotFoundException;
import ghidra.program.model.lang.Language;
import ghidra.program.model.lang.LanguageDescription;
import ghidra.program.model.lang.LanguageID;
import ghidra.program.model.lang.LanguageNotFoundException;
import ghidra.program.model.lang.LanguageService;
import ghidra.program.model.lang.SleighLanguageDescription;
import ghidra.program.model.listing.Program;
import ghidra.program.util.DefaultLanguageService;
import ghidra.util.HelpLocation;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

@PluginInfo(status=PluginStatus.RELEASED, packageName="Ghidra Core", category="Common", shortDescription="Displays program information", description="This plugin provides an action that displays information about the currently loaded program")
public class AboutProgramPlugin
extends Plugin
implements ApplicationLevelPlugin {
    public static final String PLUGIN_NAME = "AboutProgramPlugin";
    public static final String ACTION_NAME = "About Program";
    private DockingAction aboutAction;

    public AboutProgramPlugin(PluginTool tool) {
        super(tool);
    }

    protected void init() {
        this.setupActions();
    }

    public void dispose() {
        this.tool.removeAction((DockingActionIf)this.aboutAction);
        this.aboutAction.dispose();
        super.dispose();
    }

    private void addLanguageFileInfo(Map<String, String> metadata) {
        LcspAndVersion lav = LcspAndVersion.fromMetadata(metadata);
        if (lav == null || lav.language == null) {
            return;
        }
        LanguageDescription languageDescription = lav.language.getLanguageDescription();
        if (languageDescription instanceof SleighLanguageDescription) {
            SleighLanguageDescription lDesc = (SleighLanguageDescription)languageDescription;
            metadata.put("Language Spec", String.valueOf(lDesc.getDefsFile()) + (lav.isMismatch() ? lav.getVersionDisplay() : ""));
            metadata.put("Processor Spec", lDesc.getSpecFile().getAbsolutePath());
            metadata.put("Sleigh Spec", lDesc.getSlaFile().getAbsolutePath() + "spec");
        }
        if (lav.compilerSpec != null) {
            metadata.put("Compiler Spec", lav.compilerSpec.getCompilerSpecDescription().getSource());
        }
    }

    private void setupActions() {
        if (this.tool instanceof FrontEndTool) {
            this.aboutAction = new FrontendProjectTreeAction(ACTION_NAME, PLUGIN_NAME){

                protected void actionPerformed(ProjectDataContext context) {
                    DomainFile domainFile = (DomainFile)context.getSelectedFiles().get(0);
                    LinkedHashMap<String, String> metadata = new LinkedHashMap<String, String>(domainFile.getMetadata());
                    AboutProgramPlugin.this.addLanguageFileInfo(metadata);
                    AboutProgramPlugin.this.showAbout(domainFile, metadata);
                }

                protected boolean isAddToPopup(ProjectDataContext context) {
                    if (context.getFileCount() == 1 && context.getFolderCount() == 0) {
                        DomainFile domainFile = (DomainFile)context.getSelectedFiles().get(0);
                        String contentType = domainFile.getContentType();
                        this.setPopupMenuData(new MenuData(new String[]{"About " + contentType}, null, "AAA"));
                        return true;
                    }
                    return false;
                }
            };
            this.aboutAction.setPopupMenuData(new MenuData(new String[]{ACTION_NAME}, null, "AAA"));
            this.aboutAction.setEnabled(true);
        } else {
            this.aboutAction = new ProgramContextAction(ACTION_NAME, PLUGIN_NAME){

                @Override
                public void actionPerformed(ProgramActionContext context) {
                    Program program = context.getProgram();
                    LinkedHashMap<String, String> metadata = new LinkedHashMap<String, String>(program.getMetadata());
                    AboutProgramPlugin.this.addLanguageFileInfo(metadata);
                    AboutProgramPlugin.this.showAbout(program.getDomainFile(), metadata);
                }

                @Override
                public boolean isValidContext(ActionContext context) {
                    ProgramActionContext pac;
                    Program program;
                    if (super.isValidContext(context) && (program = (pac = (ProgramActionContext)context).getProgram()) != null) {
                        this.getMenuBarData().setMenuItemNamePlain("About " + program.getDomainFile().getName());
                        return true;
                    }
                    this.getMenuBarData().setMenuItemName(AboutProgramPlugin.ACTION_NAME);
                    return false;
                }
            };
            this.aboutAction.addToWindowWhen(ProgramActionContext.class);
            this.aboutAction.setContextClass(ProgramActionContext.class, true);
            this.aboutAction.setMenuBarData(new MenuData(new String[]{"&Help", ACTION_NAME}, null, "ZZZ"));
            this.aboutAction.setEnabled(false);
        }
        this.aboutAction.setHelpLocation(new HelpLocation("About", "About_Program"));
        this.aboutAction.setDescription(this.getPluginDescription().getDescription());
        this.tool.addAction((DockingActionIf)this.aboutAction);
    }

    private void showAbout(DomainFile domainFile, Map<String, String> metadata) {
        HelpLocation helpLocation = new HelpLocation("About", "About_Program");
        AboutDomainObjectUtils.displayInformation((PluginTool)this.tool, (DomainFile)domainFile, metadata, (String)("About " + domainFile.getName()), null, (HelpLocation)helpLocation);
    }

    record LcspAndVersion(Language language, CompilerSpec compilerSpec, Integer languageVersion, Integer languageMinorVersion) {
        public static final Pattern LANG_PAT = Pattern.compile("(?<id>\\S+) \\((?<major>\\d+)\\.(?<minor>\\d+)\\)");

        static Language tryLang(String languageID) {
            LanguageService langServ = DefaultLanguageService.getLanguageService();
            try {
                return langServ.getLanguage(new LanguageID(languageID));
            }
            catch (LanguageNotFoundException e) {
                return null;
            }
        }

        static Integer tryInt(String i) {
            try {
                return Integer.parseInt(i);
            }
            catch (NumberFormatException e) {
                return null;
            }
        }

        static CompilerSpec tryCompiler(Language language, String compilerSpecID) {
            try {
                return language.getCompilerSpecByID(new CompilerSpecID(compilerSpecID));
            }
            catch (CompilerSpecNotFoundException e) {
                return null;
            }
        }

        public static LcspAndVersion fromMetadata(Map<String, String> metadata) {
            Integer languageMinorVersion;
            Integer languageVersion;
            Language language;
            String languageInfo = metadata.get("Language ID");
            if (languageInfo == null) {
                return null;
            }
            Matcher matcher = LANG_PAT.matcher(languageInfo);
            if (matcher.matches()) {
                language = LcspAndVersion.tryLang(matcher.group("id"));
                languageVersion = LcspAndVersion.tryInt(matcher.group("major"));
                languageMinorVersion = LcspAndVersion.tryInt(matcher.group("minor"));
            } else {
                language = LcspAndVersion.tryLang(languageInfo);
                languageVersion = null;
                languageMinorVersion = null;
            }
            if (language == null) {
                return null;
            }
            String compilerInfo = metadata.get("Compiler ID");
            if (compilerInfo == null) {
                return new LcspAndVersion(language, null, languageVersion, languageMinorVersion);
            }
            CompilerSpec compilerSpec = LcspAndVersion.tryCompiler(language, compilerInfo);
            return new LcspAndVersion(language, compilerSpec, languageVersion, languageMinorVersion);
        }

        public boolean isMismatch() {
            return !Objects.equals(this.language.getVersion(), this.languageVersion) || !Objects.equals(this.language.getMinorVersion(), this.languageMinorVersion);
        }

        public String getVersionDisplay() {
            if (this.language == null) {
                return "";
            }
            return " (%d.%d)".formatted(this.language.getVersion(), this.language.getMinorVersion());
        }
    }
}

