/*
 * Decompiled with CFR 0.152.
 */
package db.buffers;

public class ChangeMap {
    private final byte[] mapData;
    private final int maxIndex;

    public ChangeMap(byte[] mapData) {
        this.mapData = mapData;
        this.maxIndex = mapData.length * 8 - 1;
    }

    public byte[] getData() {
        return this.mapData;
    }

    void addChangeMapData(byte[] otherMapData) {
        int limit = this.mapData.length;
        if (otherMapData.length < limit) {
            limit = otherMapData.length;
        }
        for (int byteOffset = 0; byteOffset < limit; ++byteOffset) {
            int n = byteOffset;
            this.mapData[n] = (byte)(this.mapData[n] | otherMapData[byteOffset]);
        }
    }

    void setChangedIndexes(int[] indexes) {
        for (int index : indexes) {
            if (index > this.maxIndex) continue;
            int byteOffset = index / 8;
            int bitMask = 1 << index % 8;
            int n = byteOffset;
            this.mapData[n] = (byte)(this.mapData[n] | bitMask);
        }
    }

    void setUnchangedIndexes(int[] indexes) {
        for (int index : indexes) {
            if (index > this.maxIndex) continue;
            int byteOffset = index / 8;
            int bitMask = ~(1 << index % 8);
            int n = byteOffset;
            this.mapData[n] = (byte)(this.mapData[n] & bitMask);
        }
    }

    public boolean hasChanged(int index) {
        if (this.mapData == null || index > this.maxIndex) {
            return true;
        }
        int byteOffset = index / 8;
        int bitMask = 1 << index % 8;
        return (this.mapData[byteOffset] & bitMask) != 0;
    }

    public boolean containsIndex(int index) {
        return index <= this.maxIndex;
    }
}

