/*
 * Decompiled with CFR 0.152.
 */
package org.freeplane.plugin.script;

import groovy.lang.Binding;
import groovy.lang.MetaClass;
import groovy.lang.MissingMethodException;
import groovy.lang.MissingPropertyException;
import groovy.lang.Script;
import java.awt.Color;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.Collection;
import java.util.Date;
import java.util.LinkedHashMap;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import java.util.ResourceBundle;
import java.util.regex.Pattern;
import javax.swing.Icon;
import org.codehaus.groovy.runtime.InvokerHelper;
import org.freeplane.api.ControllerRO;
import org.freeplane.api.LengthUnit;
import org.freeplane.api.NodeRO;
import org.freeplane.api.Quantity;
import org.freeplane.core.resources.IFreeplanePropertyListener;
import org.freeplane.core.resources.ResourceController;
import org.freeplane.core.ui.TimePeriodUnits;
import org.freeplane.core.util.Hyperlink;
import org.freeplane.core.util.LogUtils;
import org.freeplane.features.link.LinkController;
import org.freeplane.features.map.NodeModel;
import org.freeplane.plugin.script.ExecuteScriptException;
import org.freeplane.plugin.script.GroovyStaticImports;
import org.freeplane.plugin.script.ScriptContext;
import org.freeplane.plugin.script.proxy.AbstractProxy;
import org.freeplane.plugin.script.proxy.Proxy;
import org.freeplane.plugin.script.proxy.ProxyFactory;

public abstract class FreeplaneScriptBaseClass
extends Script {
    private final Pattern nodeIdPattern = Pattern.compile("ID_\\d+");
    private final MetaClass nodeMetaClass = InvokerHelper.getMetaClass(NodeRO.class);
    private Object script;
    private Map<Object, Object> boundVariables;
    private NodeRO node;
    private ControllerRO controller;

    public FreeplaneScriptBaseClass() {
    }

    public FreeplaneScriptBaseClass(Binding binding) {
        this();
        this.setBinding(binding);
    }

    public void setBinding(Binding binding) {
        super.setBinding(binding);
        if (binding.hasVariable("node") && binding.hasVariable("c")) {
            Object nodeProxy = binding.getVariable("node");
            Object controllerProxy = binding.getVariable("c");
            this.boundVariables = binding.getVariables();
            if (nodeProxy instanceof NodeRO || nodeProxy == null) {
                this.node = (NodeRO)nodeProxy;
            }
            if (controllerProxy instanceof ControllerRO || controllerProxy == null) {
                this.controller = (ControllerRO)controllerProxy;
            }
        }
    }

    void setScript(Object script) {
        this.script = script;
    }

    FreeplaneScriptBaseClass withBinding(NodeModel node, ScriptContext scriptContext) {
        try {
            FreeplaneScriptBaseClass instance = this.boundVariables != null ? (FreeplaneScriptBaseClass)((Object)((Object)((Object)this)).getClass().newInstance()) : this;
            instance.script = this.script;
            Proxy.Controller controllerProxy = ProxyFactory.createController(scriptContext);
            Proxy.Node nodeProxy = ProxyFactory.createNode(node, scriptContext);
            Binding binding = this.createBinding(nodeProxy, controllerProxy);
            instance.setBinding(binding);
            return instance;
        }
        catch (IllegalAccessException | InstantiationException e) {
            throw new RuntimeException(e);
        }
    }

    protected Binding createBinding(NodeRO nodeProxy, ControllerRO controllerProxy) {
        Binding binding = new Binding(new LinkedHashMap(this.getBinding().getVariables()));
        binding.setVariable("c", (Object)controllerProxy);
        binding.setVariable("node", (Object)nodeProxy);
        return binding;
    }

    public Object getProperty(String property) {
        if (property.equals("node")) {
            return this.node;
        }
        if (property.equals("c")) {
            return this.controller;
        }
        if (this.nodeIdPattern.matcher(property).matches()) {
            return this.N(property);
        }
        Object boundValue = this.boundVariables.get(property);
        if (boundValue != null) {
            return boundValue;
        }
        if (this.node != null) {
            try {
                return this.nodeMetaClass.getProperty((Object)this.node, property);
            }
            catch (MissingPropertyException missingPropertyException) {
                // empty catch block
            }
        }
        return super.getProperty(property);
    }

    public Object invokeMethod(String methodName, Object args) {
        try {
            return super.invokeMethod(methodName, args);
        }
        catch (MissingMethodException mme) {
            return this.nodeMetaClass.invokeMethod((Object)this.node, methodName, args);
        }
    }

    public NodeRO N(String id) {
        NodeRO node = (NodeRO)this.getBinding().getVariable("node");
        return node.getMindMap().node(id);
    }

    public String T(String id) {
        NodeRO n = this.N(id);
        return n == null ? null : n.getText();
    }

    public Object V(String id) {
        NodeRO n = this.N(id);
        try {
            return n == null ? null : n.getValue();
        }
        catch (ExecuteScriptException e) {
            return null;
        }
    }

    public Object ifNull(Object value, Object valueIfNull) {
        return GroovyStaticImports.ifNull(value, valueIfNull);
    }

    public Long round(Double d) {
        return GroovyStaticImports.round(d);
    }

    public Double round(Double d, int precision) {
        return GroovyStaticImports.round(d, precision);
    }

    public Object parse(String text) {
        return GroovyStaticImports.parse(text);
    }

    public Object format(Object object, String formatString) {
        return GroovyStaticImports.format(object, formatString);
    }

    public Object format(Object object) {
        return GroovyStaticImports.format(object);
    }

    public Object formatDate(Date date) {
        return GroovyStaticImports.format(date);
    }

    public String toString(Object o) {
        return GroovyStaticImports.toString(o);
    }

    public void loadUri(URI uri) {
        NodeModel delegate = (NodeModel)((AbstractProxy)this.node).getDelegate();
        LinkController.getController().loadURI(delegate, new Hyperlink(uri));
    }

    public void loadUri(String link) {
        try {
            NodeModel delegate = (NodeModel)((AbstractProxy)this.node).getDelegate();
            LinkController.getController().loadURI(delegate, LinkController.createHyperlink((String)link));
        }
        catch (URISyntaxException e) {
            LogUtils.warn((Throwable)e);
        }
    }

    public String toString() {
        return "Script [" + this.script + "]";
    }

    public static class ConfigProperties {
        private final ResourceController resourceController = ResourceController.getResourceController();

        public boolean getBooleanProperty(String key) {
            return this.resourceController.getBooleanProperty(key);
        }

        public boolean getBooleanProperty(String key, boolean defaultValue) {
            return this.resourceController.getBooleanProperty(key, defaultValue);
        }

        public boolean getProperty(String key, boolean defaultValue) {
            return this.getBooleanProperty(key, defaultValue);
        }

        public <T extends Enum<T>> T getEnumProperty(String propertyName, Enum<T> defaultValue) {
            return (T)this.resourceController.getEnumProperty(propertyName, defaultValue);
        }

        public <T extends Enum<T>> T getProperty(String propertyName, Enum<T> defaultValue) {
            return this.getEnumProperty(propertyName, defaultValue);
        }

        public double getDoubleProperty(String key) {
            return this.resourceController.getDoubleProperty(key);
        }

        public double getDoubleProperty(String key, double defaultValue) {
            return this.resourceController.getDoubleProperty(key, defaultValue);
        }

        public double getProperty(String key, double defaultValue) {
            return this.getDoubleProperty(key, defaultValue);
        }

        public int getIntProperty(String key) {
            return this.resourceController.getIntProperty(key);
        }

        public int getIntProperty(String key, int defaultValue) {
            return this.resourceController.getIntProperty(key, defaultValue);
        }

        public int getProperty(String key, int defaultValue) {
            return this.getIntProperty(key, defaultValue);
        }

        public long getLongProperty(String key, long defaultValue) {
            return this.resourceController.getLongProperty(key, defaultValue);
        }

        public long getProperty(String key, long defaultValue) {
            return this.getLongProperty(key, defaultValue);
        }

        public int getLengthProperty(String name) {
            return this.resourceController.getLengthProperty(name);
        }

        public Quantity<LengthUnit> getLengthQuantityProperty(String name) {
            return this.resourceController.getLengthQuantityProperty(name);
        }

        public int getTimeProperty(String name) {
            return this.resourceController.getTimeProperty(name);
        }

        public Quantity<TimePeriodUnits> getTimeQuantityProperty(String name) {
            return this.resourceController.getTimeQuantityProperty(name);
        }

        public Color getColorProperty(String name) {
            return this.resourceController.getColorProperty(name);
        }

        public String getProperty(String key) {
            return this.resourceController.getProperty(key);
        }

        public String getProperty(String key, String value) {
            return this.resourceController.getProperty(key, value);
        }

        public String getDefaultProperty(String key) {
            return this.resourceController.getDefaultProperty(key);
        }

        public Collection<IFreeplanePropertyListener> getPropertyChangeListeners() {
            return this.resourceController.getPropertyChangeListeners();
        }

        public URL getResource(String resourcePath) {
            return this.resourceController.getResource(resourcePath);
        }

        public InputStream getResourceStream(String resFileName) throws IOException {
            return this.resourceController.getResourceStream(resFileName);
        }

        public String getResourceBaseDir() {
            return this.resourceController.getResourceBaseDir();
        }

        public String getInstallationBaseDir() {
            return this.resourceController.getInstallationBaseDir();
        }

        public String getLanguageCode() {
            return this.resourceController.getLanguageCode();
        }

        public String getDefaultLanguageCode() {
            return this.resourceController.getDefaultLanguageCode();
        }

        public void setDefaultProperty(String key, String value) {
            this.resourceController.setDefaultProperty(key, value);
        }

        public void setProperty(String property, boolean value) {
            this.resourceController.setProperty(property, value);
        }

        public void setProperty(String name, int value) {
            this.resourceController.setProperty(name, value);
        }

        public void setProperty(String name, long value) {
            this.resourceController.setProperty(name, value);
        }

        public void setProperty(String name, double value) {
            this.resourceController.setProperty(name, value);
        }

        public void setProperty(String property, String value) {
            this.resourceController.setProperty(property, value);
        }

        public Icon getIcon(String iconKey) {
            return this.resourceController.getIcon(iconKey);
        }

        public URL getIconResource(String resourcePath) {
            return this.resourceController.getIconResource(resourcePath);
        }

        public Icon getImageIcon(String iconKey) {
            return this.resourceController.getImageIcon(iconKey);
        }

        public Locale getSystemLocale() {
            return this.resourceController.getSystemLocale();
        }

        public String[] getArrayProperty(String key, String separator) {
            return this.resourceController.getArrayProperty(key, separator);
        }

        public Properties getProperties() {
            return this.resourceController.getProperties();
        }

        public String getAt(String name) {
            return this.getProperty(name);
        }

        public void setAt(String name, String value) {
            this.setProperty(name, value);
        }

        public ResourceBundle getResources() {
            return this.resourceController.getResources();
        }

        public String getFreeplaneUserDirectory() {
            return this.resourceController.getFreeplaneUserDirectory();
        }
    }
}

