/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ui.controls.resultset.panel.grouping;

import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.ActionContributionItem;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IContributionManager;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.model.DBPImage;
import org.jkiss.dbeaver.runtime.DBWorkbench;
import org.jkiss.dbeaver.ui.DBeaverIcons;
import org.jkiss.dbeaver.ui.UIUtils;
import org.jkiss.dbeaver.ui.controls.ToolbarSeparatorContribution;
import org.jkiss.dbeaver.ui.controls.resultset.IResultSetController;
import org.jkiss.dbeaver.ui.controls.resultset.IResultSetListener;
import org.jkiss.dbeaver.ui.controls.resultset.IResultSetPresentation;
import org.jkiss.dbeaver.ui.controls.resultset.ResultSetListenerAdapter;
import org.jkiss.dbeaver.ui.controls.resultset.ResultSetPresentationDescriptor;
import org.jkiss.dbeaver.ui.controls.resultset.ResultSetUtils;
import org.jkiss.dbeaver.ui.controls.resultset.ResultSetViewer;
import org.jkiss.dbeaver.ui.controls.resultset.panel.ResultSetPanelBase;
import org.jkiss.dbeaver.ui.controls.resultset.panel.grouping.GroupingResultsContainer;
import org.jkiss.dbeaver.ui.controls.resultset.panel.grouping.action.ClearGroupingAction;
import org.jkiss.dbeaver.ui.controls.resultset.panel.grouping.action.DefaultSortingAction;
import org.jkiss.dbeaver.ui.controls.resultset.panel.grouping.action.DeleteColumnAction;
import org.jkiss.dbeaver.ui.controls.resultset.panel.grouping.action.DuplicatesOnlyAction;
import org.jkiss.dbeaver.ui.controls.resultset.panel.grouping.action.EditColumnsAction;
import org.jkiss.dbeaver.ui.controls.resultset.panel.grouping.action.PercentFromTotalAction;

public class GroupingPanel
extends ResultSetPanelBase {
    private static final String PANEL_ID = "results-grouping";
    private static final String SETTINGS_SECTION_GROUPING = "panel-results-grouping";
    private IResultSetPresentation presentation;
    private IDialogSettings panelSettings;
    private GroupingResultsContainer resultsContainer;
    private Composite groupingPlaceholder;
    private IResultSetListener ownerListener;

    @Override
    public Control createContents(IResultSetPresentation presentation, Composite parent) {
        this.presentation = presentation;
        this.panelSettings = ResultSetUtils.getViewerSettings(SETTINGS_SECTION_GROUPING);
        this.loadSettings();
        this.groupingPlaceholder = new Composite(parent, 0);
        this.groupingPlaceholder.setLayout((Layout)new FillLayout());
        this.ownerListener = new ResultSetListenerAdapter(){

            @Override
            public void handleResultSetLoad() {
                GroupingPanel.this.refresh(true);
            }
        };
        return this.groupingPlaceholder;
    }

    private GroupingResultsContainer getGroupingResultsContainer() {
        if (this.resultsContainer == null) {
            this.resultsContainer = new GroupingResultsContainer(this.groupingPlaceholder, this.presentation);
            IResultSetController groupingViewer = this.resultsContainer.getResultSetController();
            groupingViewer.getControl().addDisposeListener(e -> this.presentation.getController().removeListener(this.ownerListener));
            ResultSetListenerAdapter groupingResultsListener = new ResultSetListenerAdapter(){

                @Override
                public void handleResultSetLoad() {
                    GroupingPanel.this.updateControls();
                }

                @Override
                public void handleResultSetSelectionChange(SelectionChangedEvent event) {
                }
            };
            groupingViewer.addListener(groupingResultsListener);
        }
        return this.resultsContainer;
    }

    @Override
    public boolean isDirty() {
        return !this.getGroupingResultsContainer().getGroupAttributes().isEmpty();
    }

    private void updateControls() {
        this.presentation.getController().updatePanelActions();
    }

    private void loadSettings() {
        this.panelSettings.getSection("groups");
    }

    private void saveSettings() {
        UIUtils.getSettingsSection((IDialogSettings)this.panelSettings, (String)"groups");
    }

    @Override
    public void activatePanel() {
        this.getGroupingResultsContainer();
        this.refresh(false);
        this.groupingPlaceholder.layout(true, true);
    }

    @Override
    public void deactivatePanel() {
    }

    @Override
    public void setFocus() {
    }

    @Override
    public void refresh(boolean force) {
        if (!force) {
            return;
        }
        GroupingResultsContainer groupingResultsContainer = this.getGroupingResultsContainer();
        if (this.presentation.getController().getModel().isMetadataChanged()) {
            groupingResultsContainer.clearGrouping();
        } else {
            try {
                groupingResultsContainer.rebuildGrouping();
            }
            catch (DBException e) {
                DBWorkbench.getPlatformUI().showError("Grouping error", "Can't refresh grouping query", (Throwable)e);
            }
        }
        this.groupingPlaceholder.layout(true, true);
    }

    public void contributeActions(IContributionManager manager) {
        this.fillToolBar(manager);
    }

    private void fillToolBar(IContributionManager contributionManager) {
        ActionContributionItem sortAction = new ActionContributionItem((IAction)new DefaultSortingAction(this.getGroupingResultsContainer()));
        sortAction.setMode(ActionContributionItem.MODE_FORCE_TEXT);
        contributionManager.add((IContributionItem)sortAction);
        contributionManager.add((IAction)new DuplicatesOnlyAction(this.getGroupingResultsContainer()));
        contributionManager.add((IAction)new PercentFromTotalAction(this.getGroupingResultsContainer()));
        contributionManager.add((IContributionItem)new ToolbarSeparatorContribution(true));
        contributionManager.add((IAction)new EditColumnsAction(this.getGroupingResultsContainer()));
        contributionManager.add((IAction)new DeleteColumnAction(this.getGroupingResultsContainer()));
        contributionManager.add((IContributionItem)new ToolbarSeparatorContribution(true));
        contributionManager.add((IAction)new ClearGroupingAction(this.getGroupingResultsContainer()));
    }

    private class PresentationToggleAction
    extends Action {
        private final ResultSetPresentationDescriptor presentationDescriptor;

        public PresentationToggleAction(ResultSetPresentationDescriptor presentationDescriptor) {
            super(presentationDescriptor.getLabel(), 8);
            this.presentationDescriptor = presentationDescriptor;
            this.setImageDescriptor(DBeaverIcons.getImageDescriptor((DBPImage)presentationDescriptor.getIcon()));
            this.setToolTipText(presentationDescriptor.getDescription());
        }

        public boolean isChecked() {
            return this.presentationDescriptor.matches(GroupingPanel.this.getGroupingResultsContainer().getResultSetController().getActivePresentation().getClass());
        }

        public void run() {
            ((ResultSetViewer)GroupingPanel.this.getGroupingResultsContainer().getResultSetController()).switchPresentation(this.presentationDescriptor);
        }
    }
}

