// Copyright (c) Microsoft Corporation.
// Licensed under the MIT License.
import { logger as coreLogger } from "../log.js";
import { logPolicyName as tspLogPolicyName, logPolicy as tspLogPolicy, } from "@typespec/ts-http-runtime/internal/policies";
/**
 * The programmatic identifier of the logPolicy.
 */
export const logPolicyName = tspLogPolicyName;
/**
 * A policy that logs all requests and responses.
 * @param options - Options to configure logPolicy.
 */
export function logPolicy(options = {}) {
    return tspLogPolicy({
        logger: coreLogger.info,
        ...options,
    });
}//# sourceMappingURL=https://main.vscode-cdn.net/sourcemaps/ac4cbdf48759c7d8c3eb91ffe6bb04316e263c57/node_modules/@azure/core-rest-pipeline/dist/esm/policies/logPolicy.js.map