﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#pragma once
#include <aws/core/utils/memory/stl/AWSString.h>
#include <aws/core/utils/memory/stl/AWSVector.h>
#include <aws/ec2/EC2Request.h>
#include <aws/ec2/EC2_EXPORTS.h>
#include <aws/ec2/model/Filter.h>

#include <utility>

namespace Aws {
namespace EC2 {
namespace Model {

/**
 */
class DescribeLocalGatewayRouteTableVirtualInterfaceGroupAssociationsRequest : public EC2Request {
 public:
  AWS_EC2_API DescribeLocalGatewayRouteTableVirtualInterfaceGroupAssociationsRequest() = default;

  // Service request name is the Operation name which will send this request out,
  // each operation should has unique request name, so that we can get operation's name from this request.
  // Note: this is not true for response, multiple operations may have the same response name,
  // so we can not get operation's name from response.
  inline virtual const char* GetServiceRequestName() const override {
    return "DescribeLocalGatewayRouteTableVirtualInterfaceGroupAssociations";
  }

  AWS_EC2_API Aws::String SerializePayload() const override;

 protected:
  AWS_EC2_API void DumpBodyToUrl(Aws::Http::URI& uri) const override;

 public:
  ///@{
  /**
   * <p>The IDs of the associations.</p>
   */
  inline const Aws::Vector<Aws::String>& GetLocalGatewayRouteTableVirtualInterfaceGroupAssociationIds() const {
    return m_localGatewayRouteTableVirtualInterfaceGroupAssociationIds;
  }
  inline bool LocalGatewayRouteTableVirtualInterfaceGroupAssociationIdsHasBeenSet() const {
    return m_localGatewayRouteTableVirtualInterfaceGroupAssociationIdsHasBeenSet;
  }
  template <typename LocalGatewayRouteTableVirtualInterfaceGroupAssociationIdsT = Aws::Vector<Aws::String>>
  void SetLocalGatewayRouteTableVirtualInterfaceGroupAssociationIds(LocalGatewayRouteTableVirtualInterfaceGroupAssociationIdsT&& value) {
    m_localGatewayRouteTableVirtualInterfaceGroupAssociationIdsHasBeenSet = true;
    m_localGatewayRouteTableVirtualInterfaceGroupAssociationIds =
        std::forward<LocalGatewayRouteTableVirtualInterfaceGroupAssociationIdsT>(value);
  }
  template <typename LocalGatewayRouteTableVirtualInterfaceGroupAssociationIdsT = Aws::Vector<Aws::String>>
  DescribeLocalGatewayRouteTableVirtualInterfaceGroupAssociationsRequest& WithLocalGatewayRouteTableVirtualInterfaceGroupAssociationIds(
      LocalGatewayRouteTableVirtualInterfaceGroupAssociationIdsT&& value) {
    SetLocalGatewayRouteTableVirtualInterfaceGroupAssociationIds(
        std::forward<LocalGatewayRouteTableVirtualInterfaceGroupAssociationIdsT>(value));
    return *this;
  }
  template <typename LocalGatewayRouteTableVirtualInterfaceGroupAssociationIdsT = Aws::String>
  DescribeLocalGatewayRouteTableVirtualInterfaceGroupAssociationsRequest& AddLocalGatewayRouteTableVirtualInterfaceGroupAssociationIds(
      LocalGatewayRouteTableVirtualInterfaceGroupAssociationIdsT&& value) {
    m_localGatewayRouteTableVirtualInterfaceGroupAssociationIdsHasBeenSet = true;
    m_localGatewayRouteTableVirtualInterfaceGroupAssociationIds.emplace_back(
        std::forward<LocalGatewayRouteTableVirtualInterfaceGroupAssociationIdsT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>One or more filters.</p> <ul> <li> <p> <code>local-gateway-id</code> - The ID
   * of a local gateway.</p> </li> <li> <p>
   * <code>local-gateway-route-table-arn</code> - The Amazon Resource Name (ARN) of
   * the local gateway route table for the virtual interface group.</p> </li> <li>
   * <p> <code>local-gateway-route-table-id</code> - The ID of the local gateway
   * route table.</p> </li> <li> <p>
   * <code>local-gateway-route-table-virtual-interface-group-association-id</code> -
   * The ID of the association.</p> </li> <li> <p>
   * <code>local-gateway-route-table-virtual-interface-group-id</code> - The ID of
   * the virtual interface group.</p> </li> <li> <p> <code>owner-id</code> - The ID
   * of the Amazon Web Services account that owns the local gateway virtual interface
   * group association.</p> </li> <li> <p> <code>state</code> - The state of the
   * association.</p> </li> </ul>
   */
  inline const Aws::Vector<Filter>& GetFilters() const { return m_filters; }
  inline bool FiltersHasBeenSet() const { return m_filtersHasBeenSet; }
  template <typename FiltersT = Aws::Vector<Filter>>
  void SetFilters(FiltersT&& value) {
    m_filtersHasBeenSet = true;
    m_filters = std::forward<FiltersT>(value);
  }
  template <typename FiltersT = Aws::Vector<Filter>>
  DescribeLocalGatewayRouteTableVirtualInterfaceGroupAssociationsRequest& WithFilters(FiltersT&& value) {
    SetFilters(std::forward<FiltersT>(value));
    return *this;
  }
  template <typename FiltersT = Filter>
  DescribeLocalGatewayRouteTableVirtualInterfaceGroupAssociationsRequest& AddFilters(FiltersT&& value) {
    m_filtersHasBeenSet = true;
    m_filters.emplace_back(std::forward<FiltersT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>The maximum number of results to return with a single call. To retrieve the
   * remaining results, make another call with the returned <code>nextToken</code>
   * value.</p>
   */
  inline int GetMaxResults() const { return m_maxResults; }
  inline bool MaxResultsHasBeenSet() const { return m_maxResultsHasBeenSet; }
  inline void SetMaxResults(int value) {
    m_maxResultsHasBeenSet = true;
    m_maxResults = value;
  }
  inline DescribeLocalGatewayRouteTableVirtualInterfaceGroupAssociationsRequest& WithMaxResults(int value) {
    SetMaxResults(value);
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>The token for the next page of results.</p>
   */
  inline const Aws::String& GetNextToken() const { return m_nextToken; }
  inline bool NextTokenHasBeenSet() const { return m_nextTokenHasBeenSet; }
  template <typename NextTokenT = Aws::String>
  void SetNextToken(NextTokenT&& value) {
    m_nextTokenHasBeenSet = true;
    m_nextToken = std::forward<NextTokenT>(value);
  }
  template <typename NextTokenT = Aws::String>
  DescribeLocalGatewayRouteTableVirtualInterfaceGroupAssociationsRequest& WithNextToken(NextTokenT&& value) {
    SetNextToken(std::forward<NextTokenT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>Checks whether you have the required permissions for the action, without
   * actually making the request, and provides an error response. If you have the
   * required permissions, the error response is <code>DryRunOperation</code>.
   * Otherwise, it is <code>UnauthorizedOperation</code>.</p>
   */
  inline bool GetDryRun() const { return m_dryRun; }
  inline bool DryRunHasBeenSet() const { return m_dryRunHasBeenSet; }
  inline void SetDryRun(bool value) {
    m_dryRunHasBeenSet = true;
    m_dryRun = value;
  }
  inline DescribeLocalGatewayRouteTableVirtualInterfaceGroupAssociationsRequest& WithDryRun(bool value) {
    SetDryRun(value);
    return *this;
  }
  ///@}
 private:
  Aws::Vector<Aws::String> m_localGatewayRouteTableVirtualInterfaceGroupAssociationIds;

  Aws::Vector<Filter> m_filters;

  int m_maxResults{0};

  Aws::String m_nextToken;

  bool m_dryRun{false};
  bool m_localGatewayRouteTableVirtualInterfaceGroupAssociationIdsHasBeenSet = false;
  bool m_filtersHasBeenSet = false;
  bool m_maxResultsHasBeenSet = false;
  bool m_nextTokenHasBeenSet = false;
  bool m_dryRunHasBeenSet = false;
};

}  // namespace Model
}  // namespace EC2
}  // namespace Aws
