/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.pkg;

import java.io.IOException;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Function;
import org.apache.lucene.util.ResourceLoader;
import org.apache.lucene.util.ResourceLoaderAware;
import org.apache.solr.common.MapWriter;
import org.apache.solr.common.SolrException;
import org.apache.solr.common.cloud.SolrClassLoader;
import org.apache.solr.core.CoreContainer;
import org.apache.solr.core.PluginInfo;
import org.apache.solr.core.SolrResourceLoader;
import org.apache.solr.pkg.PackageAPI;
import org.apache.solr.pkg.PackageListeners;
import org.apache.solr.pkg.SolrPackageLoader;

public class PackageListeningClassLoader
implements SolrClassLoader,
PackageListeners.Listener {
    private final CoreContainer coreContainer;
    private final SolrClassLoader fallbackClassLoader;
    private final Function<String, String> pkgVersionSupplier;
    private Map<String, PackageAPI.PkgVersion> packageVersions = new ConcurrentHashMap<String, PackageAPI.PkgVersion>(1);
    private Map<String, String> classNameVsPackageName = new ConcurrentHashMap<String, String>();
    private final Runnable reloadAction;

    public PackageListeningClassLoader(CoreContainer coreContainer, SolrClassLoader fallbackClassLoader, Function<String, String> pkgVersionSupplier, Runnable onReload) {
        this.coreContainer = coreContainer;
        this.fallbackClassLoader = fallbackClassLoader;
        this.pkgVersionSupplier = pkgVersionSupplier;
        this.reloadAction = () -> {
            this.packageVersions = new ConcurrentHashMap<String, PackageAPI.PkgVersion>();
            this.classNameVsPackageName = new ConcurrentHashMap<String, String>();
            if (onReload != null) {
                onReload.run();
            }
        };
    }

    public <T> T newInstance(String cname, Class<T> expectedType, String ... subpackages) {
        PluginInfo.ClassName cName = new PluginInfo.ClassName(cname);
        if (cName.pkg == null) {
            return (T)this.fallbackClassLoader.newInstance(cname, expectedType, subpackages);
        }
        SolrPackageLoader.SolrPackage.Version version = this.findPackageVersion(cName, true);
        T obj = version.getLoader().newInstance(cName.className, expectedType, subpackages);
        this.classNameVsPackageName.put(cName.original, cName.pkg);
        return this.applyResourceLoaderAware(version, obj);
    }

    public SolrPackageLoader.SolrPackage.Version findPackageVersion(PluginInfo.ClassName cName, boolean registerListener) {
        SolrPackageLoader.SolrPackage p = this.coreContainer.getPackageLoader().getPackage(cName.pkg);
        if (p == null) {
            throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, "No such package: " + cName.pkg);
        }
        SolrPackageLoader.SolrPackage.Version theVersion = p.getLatest(this.pkgVersionSupplier.apply(cName.pkg));
        if (registerListener) {
            this.classNameVsPackageName.put(cName.original, cName.pkg);
            PackageAPI.PkgVersion pkgVersion = theVersion.getPkgVersion();
            if (pkgVersion != null) {
                this.packageVersions.put(cName.pkg, pkgVersion);
            }
        }
        return theVersion;
    }

    @Override
    public MapWriter getPackageVersion(PluginInfo.ClassName cName) {
        if (cName.pkg == null) {
            return null;
        }
        PackageAPI.PkgVersion p = this.packageVersions.get(cName.pkg);
        return p == null ? null : arg_0 -> ((PackageAPI.PkgVersion)p).writeMap(arg_0);
    }

    private <T> T applyResourceLoaderAware(SolrPackageLoader.SolrPackage.Version version, T obj) {
        if (obj instanceof ResourceLoaderAware) {
            SolrResourceLoader.assertAwareCompatibility(ResourceLoaderAware.class, obj);
            try {
                ((ResourceLoaderAware)obj).inform((ResourceLoader)version.getLoader());
                return obj;
            }
            catch (IOException e) {
                throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, (Throwable)e);
            }
        }
        return obj;
    }

    public <T> T newInstance(String cname, Class<T> expectedType, String[] subPackages, Class<?>[] params, Object[] args) {
        PluginInfo.ClassName cName = new PluginInfo.ClassName(cname);
        if (cName.pkg == null) {
            return (T)this.fallbackClassLoader.newInstance(cname, expectedType, subPackages, (Class[])params, args);
        }
        SolrPackageLoader.SolrPackage.Version version = this.findPackageVersion(cName, true);
        T obj = version.getLoader().newInstance(cName.className, expectedType, subPackages, params, args);
        this.classNameVsPackageName.put(cName.original, cName.pkg);
        return this.applyResourceLoaderAware(version, obj);
    }

    public <T> Class<? extends T> findClass(String cname, Class<T> expectedType) {
        PluginInfo.ClassName cName = new PluginInfo.ClassName(cname);
        if (cName.pkg == null) {
            return this.fallbackClassLoader.findClass(cname, expectedType);
        }
        SolrPackageLoader.SolrPackage.Version version = this.findPackageVersion(cName, true);
        Class<T> klas = version.getLoader().findClass(cName.className, expectedType);
        this.classNameVsPackageName.put(cName.original, cName.pkg);
        return klas;
    }

    @Override
    public String packageName() {
        return null;
    }

    @Override
    public Map<String, PackageAPI.PkgVersion> packageDetails() {
        LinkedHashMap<String, PackageAPI.PkgVersion> result = new LinkedHashMap<String, PackageAPI.PkgVersion>();
        this.classNameVsPackageName.forEach((k, v) -> result.put((String)k, this.packageVersions.get(v)));
        return result;
    }

    @Override
    public void changed(SolrPackageLoader.SolrPackage pkg, PackageListeners.Listener.Ctx ctx) {
        PackageAPI.PkgVersion currVer = this.packageVersions.get(pkg.name);
        if (currVer == null) {
            return;
        }
        String latestSupportedVersion = this.pkgVersionSupplier.apply(pkg.name);
        if (latestSupportedVersion == null) {
            latestSupportedVersion = pkg.getLatest().getVersion();
        }
        if (Objects.equals(currVer.version, latestSupportedVersion)) {
            return;
        }
        this.doReloadAction(ctx);
    }

    protected void doReloadAction(PackageListeners.Listener.Ctx ctx) {
        ctx.runLater(null, this.reloadAction);
    }
}

