/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.handler.api;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.List;
import java.util.Map;
import org.apache.solr.common.MapWriter;
import org.apache.solr.common.params.SolrParams;
import org.apache.solr.common.util.NamedList;
import org.apache.solr.common.util.StrUtils;
import org.apache.solr.common.util.Utils;
import org.apache.solr.response.SolrQueryResponse;

public class V2ApiUtils {
    private V2ApiUtils() {
    }

    public static boolean isEnabled() {
        return !"true".equals(System.getProperty("disable.v2.api", "false"));
    }

    public static void flattenMapWithPrefix(Map<String, Object> toFlatten, Map<String, Object> destination, String additionalPrefix) {
        if (toFlatten == null || toFlatten.isEmpty() || destination == null) {
            return;
        }
        toFlatten.forEach((k, v) -> destination.put(additionalPrefix + k, v));
    }

    public static void flattenToCommaDelimitedString(Map<String, Object> destination, List<String> toFlatten, String newKey) {
        String flattenedStr = String.join((CharSequence)",", toFlatten);
        destination.put(newKey, flattenedStr);
    }

    public static void squashIntoSolrResponseWithoutHeader(SolrQueryResponse rsp, Object mw) {
        V2ApiUtils.squashObjectIntoNamedList(rsp.getValues(), mw, true);
    }

    public static void squashIntoSolrResponseWithHeader(SolrQueryResponse rsp, Object mw) {
        V2ApiUtils.squashObjectIntoNamedList(rsp.getValues(), mw, false);
    }

    public static void squashIntoNamedList(NamedList<Object> destination, Object mw) {
        V2ApiUtils.squashObjectIntoNamedList(destination, mw, false);
    }

    public static void squashIntoNamedListWithoutHeader(NamedList<Object> destination, Object toSquash) {
        V2ApiUtils.squashObjectIntoNamedList(destination, toSquash, true);
    }

    public static String getMediaTypeFromWtParam(SolrParams params, String defaultMediaType) {
        if (params == null) {
            return defaultMediaType;
        }
        String wtParam = params.get("wt");
        if (StrUtils.isBlank((String)wtParam)) {
            return defaultMediaType;
        }
        switch (wtParam) {
            case "json": {
                return "application/json";
            }
            case "xml": {
                return "application/xml";
            }
            case "javabin": {
                return "application/vnd.apache.solr.javabin";
            }
            case "filestream": {
                return "application/vnd.apache.solr.raw";
            }
        }
        return defaultMediaType;
    }

    public static void squashObjectIntoNamedList(final NamedList<Object> destination, Object o, final boolean trimHeader) {
        MapWriter.EntryWriter ew = new MapWriter.EntryWriter(){

            public MapWriter.EntryWriter put(CharSequence key, Object value) {
                String kStr = key.toString();
                if (trimHeader && kStr.equals("responseHeader")) {
                    return null;
                }
                destination.add(kStr, value);
                return this;
            }
        };
        Utils.reflectWrite((MapWriter.EntryWriter)ew, (Object)o, field -> field.getAnnotation(JsonProperty.class) != null, JsonAnyGetter.class, field -> {
            JsonProperty prop = field.getAnnotation(JsonProperty.class);
            return prop.value().isEmpty() ? field.getName() : prop.value();
        });
    }
}

