/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.shaded.org.apache.curator.framework.recipes.cache;

import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReference;

class OutstandingOps {
    private final AtomicReference<Runnable> completionProc;
    private final AtomicLong count = new AtomicLong(0L);
    private volatile boolean active = true;

    OutstandingOps(Runnable completionProc) {
        this.completionProc = new AtomicReference<Runnable>(completionProc);
    }

    void increment() {
        if (this.active) {
            this.count.incrementAndGet();
        }
    }

    void decrement() {
        Runnable proc;
        if (this.active && this.count.decrementAndGet() == 0L && (proc = (Runnable)this.completionProc.getAndSet(null)) != null) {
            this.active = false;
            proc.run();
        }
    }
}

