/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.gui;

import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.GraphicsEnvironment;
import java.awt.GridBagLayout;
import java.awt.MouseInfo;
import java.awt.Point;
import java.awt.PointerInfo;
import java.awt.SystemColor;
import java.awt.Toolkit;
import java.awt.event.AWTEventListener;
import java.awt.event.ActionEvent;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.InputEvent;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.lang.reflect.InvocationTargetException;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.ConcurrentModificationException;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.stream.Collectors;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JLabel;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JProgressBar;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.Popup;
import javax.swing.PopupFactory;
import javax.swing.UIManager;
import javax.swing.event.PopupMenuEvent;
import javax.swing.event.PopupMenuListener;
import org.openstreetmap.josm.data.SystemOfMeasurement;
import org.openstreetmap.josm.data.coor.ILatLon;
import org.openstreetmap.josm.data.coor.LatLon;
import org.openstreetmap.josm.data.coor.conversion.CoordinateFormatManager;
import org.openstreetmap.josm.data.coor.conversion.DMSCoordinateFormat;
import org.openstreetmap.josm.data.coor.conversion.ICoordinateFormat;
import org.openstreetmap.josm.data.coor.conversion.ProjectedCoordinateFormat;
import org.openstreetmap.josm.data.osm.AbstractPrimitive;
import org.openstreetmap.josm.data.osm.DataSelectionListener;
import org.openstreetmap.josm.data.osm.DataSet;
import org.openstreetmap.josm.data.osm.DefaultNameFormatter;
import org.openstreetmap.josm.data.osm.IPrimitive;
import org.openstreetmap.josm.data.osm.OsmPrimitive;
import org.openstreetmap.josm.data.osm.Way;
import org.openstreetmap.josm.data.osm.event.AbstractDatasetChangedEvent;
import org.openstreetmap.josm.data.osm.event.DataChangedEvent;
import org.openstreetmap.josm.data.osm.event.DataSetListener;
import org.openstreetmap.josm.data.osm.event.DatasetEventManager;
import org.openstreetmap.josm.data.osm.event.NodeMovedEvent;
import org.openstreetmap.josm.data.osm.event.PrimitivesAddedEvent;
import org.openstreetmap.josm.data.osm.event.PrimitivesRemovedEvent;
import org.openstreetmap.josm.data.osm.event.RelationMembersChangedEvent;
import org.openstreetmap.josm.data.osm.event.SelectionEventManager;
import org.openstreetmap.josm.data.osm.event.TagsChangedEvent;
import org.openstreetmap.josm.data.osm.event.WayNodesChangedEvent;
import org.openstreetmap.josm.data.preferences.AbstractProperty;
import org.openstreetmap.josm.data.preferences.BooleanProperty;
import org.openstreetmap.josm.data.preferences.DoubleProperty;
import org.openstreetmap.josm.data.preferences.NamedColorProperty;
import org.openstreetmap.josm.gui.MainApplication;
import org.openstreetmap.josm.gui.MapFrame;
import org.openstreetmap.josm.gui.MapView;
import org.openstreetmap.josm.gui.NavigatableComponent;
import org.openstreetmap.josm.gui.Notification;
import org.openstreetmap.josm.gui.help.HelpUtil;
import org.openstreetmap.josm.gui.help.Helpful;
import org.openstreetmap.josm.gui.progress.swing.PleaseWaitProgressMonitor;
import org.openstreetmap.josm.gui.util.GuiHelper;
import org.openstreetmap.josm.gui.widgets.ImageLabel;
import org.openstreetmap.josm.gui.widgets.JosmTextField;
import org.openstreetmap.josm.spi.preferences.Config;
import org.openstreetmap.josm.spi.preferences.PreferenceChangeEvent;
import org.openstreetmap.josm.spi.preferences.PreferenceChangedListener;
import org.openstreetmap.josm.tools.ColorHelper;
import org.openstreetmap.josm.tools.Destroyable;
import org.openstreetmap.josm.tools.GBC;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.ImageProvider;
import org.openstreetmap.josm.tools.Logging;
import org.openstreetmap.josm.tools.SubclassFilteredCollection;
import org.openstreetmap.josm.tools.Utils;

public final class MapStatus
extends JPanel
implements Helpful,
Destroyable,
PreferenceChangedListener,
SystemOfMeasurement.SoMChangeListener,
DataSelectionListener,
DataSetListener,
NavigatableComponent.ZoomChangeListener {
    private final DecimalFormat DECIMAL_FORMAT = new DecimalFormat(Config.getPref().get("statusbar.decimal-format", "0.00"));
    private static final AbstractProperty<Double> DISTANCE_THRESHOLD = new DoubleProperty("statusbar.distance-threshold", 0.01).cached();
    private static final AbstractProperty<Boolean> SHOW_ID = new BooleanProperty("osm-primitives.showid", false);
    private static final List<SystemOfMeasurement> SORTED_SYSTEM_OF_MEASUREMENTS = SystemOfMeasurement.ALL_SYSTEMS.values().stream().sorted(Comparator.comparing(SystemOfMeasurement::toString)).collect(Collectors.toList());
    public static final NamedColorProperty PROP_BACKGROUND_COLOR = new NamedColorProperty(I18n.marktr("Status bar background"), ColorHelper.html2color("#b8cfe5"));
    public static final NamedColorProperty PROP_ACTIVE_BACKGROUND_COLOR = new NamedColorProperty(I18n.marktr("Status bar background: active"), ColorHelper.html2color("#aaff5e"));
    public static final NamedColorProperty PROP_FOREGROUND_COLOR = new NamedColorProperty(I18n.marktr("Status bar foreground"), Color.black);
    public static final NamedColorProperty PROP_ACTIVE_FOREGROUND_COLOR = new NamedColorProperty(I18n.marktr("Status bar foreground: active"), Color.black);
    private final MapView mv;
    private final transient Collector collector;
    private transient ICoordinateFormat previousCoordinateFormat;
    private final ImageLabel latText = new ImageLabel("lat", null, DMSCoordinateFormat.INSTANCE.latToString(LatLon.SOUTH_POLE).length(), PROP_BACKGROUND_COLOR.get());
    private final ImageLabel lonText = new ImageLabel("lon", null, DMSCoordinateFormat.INSTANCE.lonToString(new LatLon(0.0, 180.0)).length(), PROP_BACKGROUND_COLOR.get());
    private final ImageLabel headingText = new ImageLabel("heading", I18n.tr("The (compass) heading of the line segment being drawn.", new Object[0]), this.DECIMAL_FORMAT.format(360L).length() + 1, PROP_BACKGROUND_COLOR.get());
    private final ImageLabel angleText = new ImageLabel("angle", I18n.tr("The angle between the previous and the current way segment.", new Object[0]), this.DECIMAL_FORMAT.format(360L).length() + 1, PROP_BACKGROUND_COLOR.get());
    private final ImageLabel distText = new ImageLabel("dist", I18n.tr("The length of the new way segment being drawn.", new Object[0]), 10, PROP_BACKGROUND_COLOR.get());
    private final ImageLabel nameText = new ImageLabel("name", I18n.tr("The name of the object at the mouse pointer.", new Object[0]), MapStatus.getNameLabelCharacterCount(MainApplication.getMainFrame()), PROP_BACKGROUND_COLOR.get());
    private final JosmTextField helpText = new JosmTextField(null, null, 0, false);
    private final JProgressBar progressBar = new JProgressBar();
    private final transient ComponentAdapter mvComponentAdapter;
    public final transient BackgroundProgressMonitor progressMonitor = new BackgroundProgressMonitor();
    private double distValue;
    private boolean angleEnabled;
    private final transient Thread thread;
    private final transient List<StatusTextHistory> statusText = new ArrayList<StatusTextHistory>();
    private final transient AWTEventListener awtListener;
    private final transient MouseMotionListener mouseMotionListener = new MouseMotionListener(){

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void mouseMoved(MouseEvent e) {
            Collector collector = MapStatus.this.collector;
            synchronized (collector) {
                MapStatus.this.collector.updateMousePosition(e.getPoint(), e.getModifiersEx());
            }
        }

        @Override
        public void mouseDragged(MouseEvent e) {
            this.mouseMoved(e);
        }
    };
    private final transient KeyAdapter keyAdapter = new KeyAdapter(){

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void keyPressed(KeyEvent e) {
            Collector collector = MapStatus.this.collector;
            synchronized (collector) {
                MapStatus.this.collector.updateMousePosition(null, e.getModifiersEx());
            }
        }

        @Override
        public void keyReleased(KeyEvent e) {
            this.keyPressed(e);
        }
    };
    private boolean autoLength = true;

    private void registerListeners() {
        try {
            Toolkit.getDefaultToolkit().addAWTEventListener(this.awtListener, 56L);
        }
        catch (SecurityException ex) {
            Logging.trace(ex);
            this.mv.addMouseMotionListener(this.mouseMotionListener);
            this.mv.addKeyListener(this.keyAdapter);
        }
    }

    private void unregisterListeners() {
        try {
            Toolkit.getDefaultToolkit().removeAWTEventListener(this.awtListener);
        }
        catch (SecurityException e) {
            Logging.trace(e);
        }
        this.mv.removeMouseMotionListener(this.mouseMotionListener);
        this.mv.removeKeyListener(this.keyAdapter);
    }

    public MapStatus(MapFrame mapFrame) {
        this.mv = mapFrame.mapView;
        this.collector = new Collector(mapFrame);
        this.awtListener = event -> {
            if (event instanceof InputEvent && ((InputEvent)event).getComponent() == this.mv) {
                Collector collector = this.collector;
                synchronized (collector) {
                    int modifiers = ((InputEvent)event).getModifiersEx();
                    Point mousePos = null;
                    if (event instanceof MouseEvent) {
                        mousePos = ((MouseEvent)event).getPoint();
                    }
                    this.collector.updateMousePosition(mousePos, modifiers);
                }
            }
        };
        this.setComponentPopupMenu(new MapStatusPopupMenu());
        JumpToOnLeftClickMouseAdapter jumpToOnLeftClick = new JumpToOnLeftClickMouseAdapter();
        this.mv.addMouseMotionListener(new MouseMotionListener(){

            @Override
            public void mouseDragged(MouseEvent e) {
                this.mouseMoved(e);
            }

            @Override
            public void mouseMoved(MouseEvent e) {
                if (MapStatus.this.mv.getCenter() == null) {
                    return;
                }
                if ((e.getModifiersEx() & 0x1080) == 0) {
                    MapStatus.this.updateLatLonText(e.getX(), e.getY());
                }
            }
        });
        this.setLayout(new GridBagLayout());
        this.setBorder(BorderFactory.createEmptyBorder(1, 2, 1, 2));
        this.latText.setForeground(PROP_FOREGROUND_COLOR.get());
        this.lonText.setForeground(PROP_FOREGROUND_COLOR.get());
        this.headingText.setForeground(PROP_FOREGROUND_COLOR.get());
        this.distText.setForeground(PROP_FOREGROUND_COLOR.get());
        this.nameText.setForeground(PROP_FOREGROUND_COLOR.get());
        this.latText.setInheritsPopupMenu(true);
        this.lonText.setInheritsPopupMenu(true);
        this.headingText.setInheritsPopupMenu(true);
        this.distText.setInheritsPopupMenu(true);
        this.nameText.setInheritsPopupMenu(true);
        this.add((Component)this.latText, GBC.std());
        this.add((Component)this.lonText, GBC.std().insets(3, 0, 0, 0));
        this.add((Component)this.headingText, GBC.std().insets(3, 0, 0, 0));
        this.add((Component)this.angleText, GBC.std().insets(3, 0, 0, 0));
        this.add((Component)this.distText, GBC.std().insets(3, 0, 0, 0));
        if (Config.getPref().getBoolean("statusbar.change-system-of-measurement-on-click", true)) {
            this.distText.addMouseListener(new MouseAdapter(){

                @Override
                public void mouseClicked(MouseEvent e) {
                    if (!e.isPopupTrigger() && e.getButton() == 1) {
                        SystemOfMeasurement som = SystemOfMeasurement.getSystemOfMeasurement();
                        int i = (SORTED_SYSTEM_OF_MEASUREMENTS.indexOf(som) + 1) % SORTED_SYSTEM_OF_MEASUREMENTS.size();
                        SystemOfMeasurement newsom = SORTED_SYSTEM_OF_MEASUREMENTS.get(i);
                        MapStatus.this.updateSystemOfMeasurement(newsom);
                    }
                }
            });
        }
        SystemOfMeasurement.addSoMChangeListener(this);
        NavigatableComponent.addZoomChangeListener(this);
        this.latText.addMouseListener(jumpToOnLeftClick);
        this.lonText.addMouseListener(jumpToOnLeftClick);
        this.helpText.setEditable(false);
        this.add((Component)this.nameText, GBC.std().insets(3, 0, 0, 0));
        this.add((Component)this.helpText, GBC.std().insets(3, 0, 0, 0).fill(2));
        this.progressBar.setMaximum(10000);
        this.progressBar.setVisible(false);
        GBC gbc = GBC.eol();
        gbc.ipadx = 100;
        this.add((Component)this.progressBar, gbc);
        this.progressBar.addMouseListener(new ShowMonitorDialogMouseAdapter());
        Config.getPref().addPreferenceChangeListener(this);
        DatasetEventManager.getInstance().addDatasetListener(this, DatasetEventManager.FireMode.IN_EDT_CONSOLIDATED);
        SelectionEventManager.getInstance().addSelectionListenerForEdt(this);
        this.mvComponentAdapter = new ComponentAdapter(){

            @Override
            public void componentResized(ComponentEvent e) {
                MapStatus.this.nameText.setCharCount(MapStatus.getNameLabelCharacterCount(MainApplication.getMainFrame()));
                MapStatus.this.revalidate();
            }
        };
        this.mv.addComponentListener(this.mvComponentAdapter);
        this.thread = new Thread((Runnable)this.collector, "Map Status Collector");
        this.thread.setDaemon(true);
        this.thread.start();
    }

    private void updateLatLonText(int x, int y) {
        LatLon p = this.mv.getLatLon(x, y);
        ICoordinateFormat mCord = CoordinateFormatManager.getDefaultFormat();
        this.latText.setText(mCord.latToString(p));
        this.lonText.setText(mCord.lonToString(p));
        if (!Objects.equals(this.previousCoordinateFormat, mCord)) {
            if (ProjectedCoordinateFormat.INSTANCE.equals(mCord)) {
                this.latText.setIcon("northing");
                this.lonText.setIcon("easting");
                this.latText.setToolTipText(I18n.tr("The northing at the mouse pointer.", new Object[0]));
                this.lonText.setToolTipText(I18n.tr("The easting at the mouse pointer.", new Object[0]));
                this.previousCoordinateFormat = mCord;
            } else {
                this.latText.setIcon("lat");
                this.lonText.setIcon("lon");
                this.latText.setToolTipText(I18n.tr("The geographic latitude at the mouse pointer.", new Object[0]));
                this.lonText.setToolTipText(I18n.tr("The geographic longitude at the mouse pointer.", new Object[0]));
                this.previousCoordinateFormat = mCord;
            }
        }
    }

    @Override
    public void systemOfMeasurementChanged(String oldSoM, String newSoM) {
        this.setDist(this.distValue);
    }

    public void updateSystemOfMeasurement(SystemOfMeasurement som) {
        SystemOfMeasurement.setSystemOfMeasurement(som);
        if (Config.getPref().getBoolean("statusbar.notify.change-system-of-measurement", true)) {
            new Notification(I18n.tr("System of measurement changed to {0}", som.toString())).setIcon(1).setDuration(Notification.TIME_SHORT).show();
        }
    }

    public JPanel getAnglePanel() {
        return this.angleText;
    }

    @Override
    public String helpTopic() {
        return HelpUtil.ht("/StatusBar");
    }

    @Override
    public synchronized void addMouseListener(MouseListener ml) {
        this.lonText.addMouseListener(ml);
        this.latText.addMouseListener(ml);
    }

    public void setHelpText(String text) {
        this.setHelpText(null, text);
    }

    public synchronized void setHelpText(Object id, String text) {
        StatusTextHistory entry = new StatusTextHistory(id, text);
        this.statusText.remove(entry);
        this.statusText.add(entry);
        GuiHelper.runInEDT(() -> {
            this.helpText.setText(text);
            this.helpText.setToolTipText(text);
        });
    }

    public synchronized void resetHelpText(Object id) {
        if (this.statusText.isEmpty()) {
            return;
        }
        StatusTextHistory entry = new StatusTextHistory(id, null);
        if (this.statusText.get(this.statusText.size() - 1).equals(entry)) {
            if (this.statusText.size() == 1) {
                this.setHelpText("");
            } else {
                StatusTextHistory history = this.statusText.get(this.statusText.size() - 2);
                this.setHelpText(history.id, history.text);
            }
        }
        this.statusText.remove(entry);
    }

    public void setAngle(double a) {
        this.angleText.setText((String)(a < 0.0 ? "--" : this.DECIMAL_FORMAT.format(a) + " \u00b0"));
    }

    public void setAngleNaN(double a) {
        this.angleText.setText((String)(!Double.isFinite(a) ? "--" : this.DECIMAL_FORMAT.format(a) + " \u00b0"));
    }

    public void setAngleText(String text) {
        this.angleText.setText(text);
    }

    public void setHeading(double h) {
        this.headingText.setText((String)(h < 0.0 ? "--" : this.DECIMAL_FORMAT.format(h) + " \u00b0"));
    }

    public void setDist(double dist) {
        this.distValue = dist;
        this.distText.setText(dist < 0.0 ? "--" : NavigatableComponent.getDistText(dist, this.DECIMAL_FORMAT, DISTANCE_THRESHOLD.get()));
    }

    public void setDist(Collection<Way> ways) {
        double dist = -1.0;
        int maxWays = Math.max(1, Config.getPref().getInt("selection.max-ways-for-statusline", 250));
        if (!ways.isEmpty() && ways.size() <= maxWays) {
            dist = ways.stream().mapToDouble(Way::getLength).sum();
        }
        this.setDist(dist);
    }

    public void activateAnglePanel(boolean activeFlag) {
        this.angleEnabled = activeFlag;
        this.refreshAnglePanel();
    }

    private void refreshAnglePanel() {
        this.angleText.setBackground(this.angleEnabled ? PROP_ACTIVE_BACKGROUND_COLOR.get() : PROP_BACKGROUND_COLOR.get());
        this.angleText.setForeground(this.angleEnabled ? PROP_ACTIVE_FOREGROUND_COLOR.get() : PROP_FOREGROUND_COLOR.get());
    }

    @Override
    public void destroy() {
        SystemOfMeasurement.removeSoMChangeListener(this);
        NavigatableComponent.removeZoomChangeListener(this);
        Config.getPref().removePreferenceChangeListener(this);
        DatasetEventManager.getInstance().removeDatasetListener(this);
        SelectionEventManager.getInstance().removeSelectionListener(this);
        this.mv.removeComponentListener(this.mvComponentAdapter);
        if (this.thread != null) {
            try {
                this.thread.interrupt();
            }
            catch (SecurityException e) {
                Logging.error(e);
            }
        }
    }

    @Override
    public void preferenceChanged(PreferenceChangeEvent e) {
        String key = e.getKey();
        if (key.startsWith("clr.")) {
            if (PROP_BACKGROUND_COLOR.getKey().equals(key) || PROP_FOREGROUND_COLOR.getKey().equals(key)) {
                for (ImageLabel il : new ImageLabel[]{this.latText, this.lonText, this.headingText, this.distText, this.nameText}) {
                    il.setBackground(PROP_BACKGROUND_COLOR.get());
                    il.setForeground(PROP_FOREGROUND_COLOR.get());
                }
                this.refreshAnglePanel();
            } else if (PROP_ACTIVE_BACKGROUND_COLOR.getKey().equals(key) || PROP_ACTIVE_FOREGROUND_COLOR.getKey().equals(key)) {
                this.refreshAnglePanel();
            }
        }
    }

    public static void getColors() {
        PROP_BACKGROUND_COLOR.get();
        PROP_FOREGROUND_COLOR.get();
        PROP_ACTIVE_BACKGROUND_COLOR.get();
        PROP_ACTIVE_FOREGROUND_COLOR.get();
    }

    private static int getNameLabelCharacterCount(Component parent) {
        int w = parent != null ? parent.getWidth() : 800;
        return Math.min(80, 20 + Math.max(0, w - 1280) * 60 / 640);
    }

    private void refreshDistText(Collection<? extends OsmPrimitive> newSelection) {
        if (!this.autoLength) {
            return;
        }
        if (newSelection.size() == 2) {
            Iterator<? extends OsmPrimitive> it = newSelection.iterator();
            OsmPrimitive n1 = it.next();
            OsmPrimitive n2 = it.next();
            if (n1 instanceof ILatLon && n2 instanceof ILatLon && ((ILatLon)((Object)n1)).isLatLonKnown() && ((ILatLon)((Object)n2)).isLatLonKnown()) {
                this.setDist(((ILatLon)((Object)n1)).greatCircleDistance((ILatLon)((Object)n2)));
                return;
            }
        }
        this.setDist(new SubclassFilteredCollection(newSelection, Way.class::isInstance));
    }

    @Override
    public void selectionChanged(DataSelectionListener.SelectionChangeEvent event) {
        this.refreshDistText(event.getSelection());
    }

    @Override
    public void zoomChanged() {
        if (!GraphicsEnvironment.isHeadless()) {
            try {
                PointerInfo pointerInfo = MouseInfo.getPointerInfo();
                if (pointerInfo != null) {
                    Point mp = pointerInfo.getLocation();
                    this.updateLatLonText(mp.x, mp.y);
                }
            }
            catch (SecurityException ex) {
                Logging.log(Logging.LEVEL_ERROR, "Unable to get mouse pointer info", ex);
            }
        }
    }

    @Override
    public void wayNodesChanged(WayNodesChangedEvent event) {
        this.refreshDistText(event.getDataset().getSelected());
    }

    @Override
    public void nodeMoved(NodeMovedEvent event) {
        this.refreshDistText(event.getDataset().getSelected());
    }

    @Override
    public void primitivesAdded(PrimitivesAddedEvent event) {
    }

    @Override
    public void primitivesRemoved(PrimitivesRemovedEvent event) {
    }

    @Override
    public void tagsChanged(TagsChangedEvent event) {
    }

    @Override
    public void relationMembersChanged(RelationMembersChangedEvent event) {
    }

    @Override
    public void otherDatasetChange(AbstractDatasetChangedEvent event) {
    }

    @Override
    public void dataChanged(DataChangedEvent event) {
        if (event.getDataset() != null) {
            this.refreshDistText(event.getDataset().getSelected());
        }
    }

    public void setAutoLength(boolean b) {
        this.autoLength = b;
    }

    private class MapStatusPopupMenu
    extends JPopupMenu {
        private final JMenuItem jumpButton;
        private final Collection<JCheckBoxMenuItem> somItems;
        private final Collection<JCheckBoxMenuItem> coordinateFormatItems;
        private final JSeparator separator;
        private final JMenuItem doNotHide;

        MapStatusPopupMenu() {
            JCheckBoxMenuItem item;
            this.jumpButton = this.add(MainApplication.getMenu().jumpToAct);
            this.somItems = new ArrayList<JCheckBoxMenuItem>();
            this.coordinateFormatItems = new ArrayList<JCheckBoxMenuItem>();
            this.separator = new JSeparator();
            this.doNotHide = new JCheckBoxMenuItem(new AbstractAction(I18n.tr("Do not hide status bar", new Object[0])){

                @Override
                public void actionPerformed(ActionEvent e) {
                    boolean sel = ((JCheckBoxMenuItem)e.getSource()).getState();
                    Config.getPref().putBoolean("statusbar.always-visible", sel);
                }
            });
            for (final SystemOfMeasurement som : SORTED_SYSTEM_OF_MEASUREMENTS) {
                item = new JCheckBoxMenuItem(new AbstractAction(som.toString()){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        MapStatus.this.updateSystemOfMeasurement(som);
                    }
                });
                this.somItems.add(item);
                this.add(item);
            }
            for (final ICoordinateFormat format : CoordinateFormatManager.getCoordinateFormats()) {
                item = new JCheckBoxMenuItem(new AbstractAction(format.getDisplayName()){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        CoordinateFormatManager.setCoordinateFormat(format);
                    }
                });
                this.coordinateFormatItems.add(item);
                this.add(item);
            }
            this.add(this.separator);
            this.add(this.doNotHide);
            this.addPopupMenuListener(new PopupMenuListener(){

                @Override
                public void popupMenuWillBecomeVisible(PopupMenuEvent e) {
                    Component invoker = ((JPopupMenu)e.getSource()).getInvoker();
                    MapStatusPopupMenu.this.jumpButton.setVisible(MapStatus.this.latText.equals(invoker) || MapStatus.this.lonText.equals(invoker));
                    String currentSOM = SystemOfMeasurement.getSystemOfMeasurement().toString();
                    for (JMenuItem jMenuItem : MapStatusPopupMenu.this.somItems) {
                        jMenuItem.setSelected(jMenuItem.getText().equals(currentSOM));
                        jMenuItem.setVisible(MapStatus.this.distText.equals(invoker));
                    }
                    String currentCorrdinateFormat = CoordinateFormatManager.getDefaultFormat().getDisplayName();
                    for (JMenuItem jMenuItem : MapStatusPopupMenu.this.coordinateFormatItems) {
                        jMenuItem.setSelected(currentCorrdinateFormat.equals(jMenuItem.getText()));
                        jMenuItem.setVisible(MapStatus.this.latText.equals(invoker) || MapStatus.this.lonText.equals(invoker));
                    }
                    MapStatusPopupMenu.this.separator.setVisible(MapStatus.this.distText.equals(invoker) || MapStatus.this.latText.equals(invoker) || MapStatus.this.lonText.equals(invoker));
                    MapStatusPopupMenu.this.doNotHide.setSelected(Config.getPref().getBoolean("statusbar.always-visible", true));
                }

                @Override
                public void popupMenuWillBecomeInvisible(PopupMenuEvent e) {
                }

                @Override
                public void popupMenuCanceled(PopupMenuEvent e) {
                }
            });
        }
    }

    private static class MouseState {
        private final Point mousePos;
        private final int modifiers;

        MouseState(Point mousePos, int modifiers) {
            this.mousePos = mousePos;
            this.modifiers = modifiers;
        }
    }

    private final class Collector
    implements Runnable {
        private Point oldMousePos;
        private List<JLabel> popupLabels;
        private Popup popup;
        private final MapFrame parent;
        private final BlockingQueue<MouseState> incomingMouseState = new LinkedBlockingQueue<MouseState>();
        private Point lastMousePos;

        Collector(MapFrame parent) {
            this.parent = parent;
        }

        /*
         * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Override
        public void run() {
            MapStatus.this.registerListeners();
            while (true) {
                MouseState ms;
                try {
                    ms = this.incomingMouseState.take();
                    if (this.parent != MainApplication.getMap()) {
                        MapStatus.this.unregisterListeners();
                        return;
                    }
                }
                catch (InvocationTargetException e) {
                    Logging.warn(e);
                }
                catch (InterruptedException e) {
                    Logging.trace("InterruptedException in " + MapStatus.class.getSimpleName());
                    Thread.currentThread().interrupt();
                    MapStatus.this.unregisterListeners();
                    return;
                }
                catch (Throwable throwable) {
                    MapStatus.this.unregisterListeners();
                    throw throwable;
                }
                {
                    if (ms.mousePos == null || MapStatus.this.mv.getCenter() == null) continue;
                    EventQueue.invokeAndWait(new CollectorWorker(ms));
                    continue;
                }
                break;
            }
        }

        private Popup popupCreatePopup(Component content, MouseState ms) {
            int yPos;
            Point p = MapStatus.this.mv.getLocationOnScreen();
            Dimension scrn = GuiHelper.getScreenSize();
            JScrollPane sp = GuiHelper.embedInVerticalScrollPane(content);
            sp.setBorder(BorderFactory.createRaisedBevelBorder());
            Dimension prefsize = sp.getPreferredSize();
            int w = Math.min(prefsize.width, Math.min(800, scrn.width / 2 - 16));
            int h = Math.min(prefsize.height, scrn.height - 10);
            sp.setPreferredSize(new Dimension(w, h));
            int xPos = p.x + ms.mousePos.x + 16;
            if (xPos + w > scrn.width && xPos > scrn.width / 2) {
                xPos = p.x + ms.mousePos.x - 4 - w;
            }
            if ((yPos = p.y + ms.mousePos.y + 16) + h > scrn.height - 5) {
                yPos = Math.max(5, scrn.height - h - 5);
            }
            PopupFactory pf = PopupFactory.getSharedInstance();
            return pf.getPopup(MapStatus.this.mv, sp, xPos, yPos);
        }

        private void statusBarElementUpdate(MouseState ms) {
            OsmPrimitive osmNearest = MapStatus.this.mv.getNearestNodeOrWay(ms.mousePos, AbstractPrimitive::isUsable, false);
            if (osmNearest != null) {
                MapStatus.this.nameText.setText(osmNearest.getDisplayName(DefaultNameFormatter.getInstance()));
            } else {
                MapStatus.this.nameText.setText(I18n.tr("(no object)", new Object[0]));
            }
        }

        private void popupCycleSelection(Collection<OsmPrimitive> osms, int mods) {
            DataSet ds = MainApplication.getLayerManager().getActiveDataSet();
            OsmPrimitive firstItem = null;
            OsmPrimitive firstSelected = null;
            OsmPrimitive nextSelected = null;
            for (OsmPrimitive osm : osms) {
                if (firstItem == null) {
                    firstItem = osm;
                }
                if (firstSelected != null && nextSelected == null) {
                    nextSelected = osm;
                }
                if (firstSelected != null || !ds.isSelected(osm)) continue;
                firstSelected = osm;
            }
            if ((mods & 0x40) == 0) {
                ds.clearSelection();
            }
            if (firstSelected != null) {
                ds.clearSelection(firstSelected);
                if (nextSelected != null) {
                    ds.addSelected(nextSelected);
                }
            } else if (firstItem != null) {
                ds.addSelected(firstItem);
            }
        }

        private void popupHidePopup() {
            this.popupLabels = null;
            if (this.popup == null) {
                return;
            }
            Popup staticPopup = this.popup;
            this.popup = null;
            EventQueue.invokeLater(staticPopup::hide);
        }

        private void popupShowPopup(Popup newPopup, List<JLabel> lbls) {
            Popup staticPopup = newPopup;
            if (this.popup != null) {
                Popup staticOldPopup = this.popup;
                EventQueue.invokeLater(() -> {
                    staticPopup.show();
                    staticOldPopup.hide();
                });
            } else {
                EventQueue.invokeLater(staticPopup::show);
            }
            this.popupLabels = lbls;
            this.popup = newPopup;
        }

        private void popupUpdateLabels() {
            if (this.popup == null || this.popupLabels == null) {
                return;
            }
            for (JLabel l : this.popupLabels) {
                l.validate();
            }
        }

        private void popupSetLabelColors(JLabel lbl, IPrimitive osm) {
            if (osm.isSelected()) {
                lbl.setBackground(SystemColor.textHighlight);
                lbl.setForeground(SystemColor.textHighlightText);
            } else {
                lbl.setBackground(SystemColor.control);
                lbl.setForeground(SystemColor.controlText);
            }
        }

        private JLabel popupBuildPrimitiveLabels(final OsmPrimitive osm) {
            StringBuilder text = new StringBuilder(32);
            Object name = Utils.escapeReservedCharactersHTML(osm.getDisplayName(DefaultNameFormatter.getInstance()));
            if (osm.isNewOrUndeleted() || osm.isModified()) {
                name = "<i><b>" + (String)name + "*</b></i>";
            }
            text.append((String)name);
            boolean idShown = SHOW_ID.get();
            if (!osm.isNew() && !idShown) {
                text.append(" [id=").append(osm.getId()).append(']');
            }
            if (osm.getUser() != null) {
                text.append(" [").append(I18n.tr("User:", new Object[0])).append(' ').append(Utils.escapeReservedCharactersHTML(osm.getUser().getName())).append(']');
            }
            osm.visitKeys((primitive, key, value) -> text.append("<br>").append(key).append('=').append(value));
            final JLabel l = new JLabel("<html>" + text.toString() + "</html>", ImageProvider.get(osm.getDisplayType()), 0){

                @Override
                public void validate() {
                    super.validate();
                    Collector.this.popupSetLabelColors(this, osm);
                }
            };
            l.setOpaque(true);
            this.popupSetLabelColors(l, osm);
            l.setFont(l.getFont().deriveFont(0));
            l.setVerticalTextPosition(1);
            l.setHorizontalAlignment(10);
            l.setCursor(Cursor.getPredefinedCursor(12));
            l.addMouseListener(new MouseAdapter(){

                @Override
                public void mouseEntered(MouseEvent e) {
                    l.setBackground(SystemColor.info);
                    l.setForeground(SystemColor.infoText);
                }

                @Override
                public void mouseExited(MouseEvent e) {
                    Collector.this.popupSetLabelColors(l, osm);
                }

                @Override
                public void mouseClicked(MouseEvent e) {
                    DataSet ds = MainApplication.getLayerManager().getActiveDataSet();
                    ds.toggleSelected(osm);
                    l.validate();
                }
            });
            l.addMouseMotionListener(new MouseMotionListener(){

                @Override
                public void mouseMoved(MouseEvent e) {
                    l.setBackground(SystemColor.info);
                    l.setForeground(SystemColor.infoText);
                }

                @Override
                public void mouseDragged(MouseEvent e) {
                    this.mouseMoved(e);
                }
            });
            return l;
        }

        public synchronized void updateMousePosition(Point mousePos, int modifiers) {
            if (mousePos != null) {
                this.lastMousePos = mousePos;
            }
            MouseState ms = new MouseState(this.lastMousePos, modifiers);
            this.incomingMouseState.clear();
            if (!this.incomingMouseState.offer(ms)) {
                Logging.warn("Unable to handle new MouseState: " + String.valueOf(ms));
            }
        }

        private final class CollectorWorker
        implements Runnable {
            private final MouseState ms;

            private CollectorWorker(MouseState ms) {
                this.ms = ms;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                if ((this.ms.modifiers & 0x80) != 0) {
                    Collector.this.popupUpdateLabels();
                    return;
                }
                boolean mouseNotMoved = Collector.this.oldMousePos != null && Collector.this.oldMousePos.equals(this.ms.mousePos);
                boolean isAtOldPosition = mouseNotMoved && Collector.this.popup != null;
                boolean middleMouseDown = (this.ms.modifiers & 0x800) != 0;
                DataSet ds = MapStatus.this.mv.getLayerManager().getActiveDataSet();
                if (ds != null) {
                    if (isAtOldPosition && middleMouseDown) {
                        ds.beginUpdate();
                    } else {
                        ds.getReadLock().lock();
                    }
                }
                try {
                    if (!mouseNotMoved) {
                        Collector.this.statusBarElementUpdate(this.ms);
                    }
                    if (middleMouseDown || isAtOldPosition) {
                        List<OsmPrimitive> osms = MapStatus.this.mv.getAllNearest(this.ms.mousePos, OsmPrimitive::isSelectable);
                        JPanel c = new JPanel(new GridBagLayout());
                        JLabel lbl = new JLabel("<html>" + I18n.tr("Middle click again to cycle through.<br>Hold CTRL to select directly from this list with the mouse.<hr>", new Object[0]) + "</html>", null, 0);
                        lbl.setHorizontalAlignment(10);
                        c.add((Component)lbl, GBC.eol().insets(2, 0, 2, 0));
                        if (isAtOldPosition && middleMouseDown) {
                            Collector.this.popupCycleSelection(osms, this.ms.modifiers);
                        }
                        ArrayList<JLabel> lbls = new ArrayList<JLabel>(osms.size());
                        for (OsmPrimitive osm : osms) {
                            JLabel l = Collector.this.popupBuildPrimitiveLabels(osm);
                            lbls.add(l);
                            c.add((Component)l, GBC.eol().fill(2).insets(2, 0, 2, 2));
                        }
                        Collector.this.popupShowPopup(Collector.this.popupCreatePopup(c, this.ms), lbls);
                    } else {
                        Collector.this.popupHidePopup();
                    }
                    Collector.this.oldMousePos = this.ms.mousePos;
                }
                catch (ConcurrentModificationException ex) {
                    Logging.warn(ex);
                }
                finally {
                    if (ds != null) {
                        if (isAtOldPosition && middleMouseDown) {
                            ds.endUpdate();
                        } else {
                            ds.getReadLock().unlock();
                        }
                    }
                }
            }
        }
    }

    protected static final class StatusTextHistory {
        private final Object id;
        private final String text;

        StatusTextHistory(Object id, String text) {
            this.id = id;
            this.text = text;
        }

        public boolean equals(Object obj) {
            return obj instanceof StatusTextHistory && ((StatusTextHistory)obj).id == this.id;
        }

        public int hashCode() {
            return System.identityHashCode(this.id);
        }
    }

    public class BackgroundProgressMonitor
    implements PleaseWaitProgressMonitor.ProgressMonitorDialog {
        private String title;
        private String customText;

        private void updateText() {
            if (!Utils.isEmpty(this.customText)) {
                MapStatus.this.progressBar.setToolTipText(I18n.tr("{0} ({1})", this.title, this.customText));
            } else {
                MapStatus.this.progressBar.setToolTipText(this.title);
            }
        }

        @Override
        public void setVisible(boolean visible) {
            MapStatus.this.progressBar.setVisible(visible);
        }

        @Override
        public void updateProgress(int progress) {
            MapStatus.this.progressBar.setValue(progress);
            MapStatus.this.progressBar.repaint();
            MapStatus.this.doLayout();
        }

        @Override
        public void setCustomText(String text) {
            this.customText = text;
            this.updateText();
        }

        @Override
        public void setCurrentAction(String text) {
            this.title = text;
            this.updateText();
        }

        @Override
        public void setIndeterminate(boolean newValue) {
            UIManager.put("ProgressBar.cycleTime", UIManager.getInt("ProgressBar.repaintInterval") * 100);
            MapStatus.this.progressBar.setIndeterminate(newValue);
        }

        @Override
        public void appendLogMessage(String message) {
            if (!Utils.isEmpty(message)) {
                Logging.info("appendLogMessage not implemented for background tasks. Message was: " + message);
            }
        }
    }

    static final class JumpToOnLeftClickMouseAdapter
    extends MouseAdapter {
        JumpToOnLeftClickMouseAdapter() {
        }

        @Override
        public void mouseClicked(MouseEvent e) {
            if (e.getButton() != 3) {
                MainApplication.getMenu().jumpToAct.showJumpToDialog();
            }
        }
    }

    static final class ShowMonitorDialogMouseAdapter
    extends MouseAdapter {
        ShowMonitorDialogMouseAdapter() {
        }

        @Override
        public void mouseClicked(MouseEvent e) {
            PleaseWaitProgressMonitor monitor = PleaseWaitProgressMonitor.getCurrent();
            if (monitor != null) {
                monitor.showForegroundDialog();
            }
        }
    }
}

