/*
 * Decompiled with CFR 0.152.
 */
package io.github.dan2097.jnainchi;

import io.github.dan2097.jnainchi.InchiAtom;
import io.github.dan2097.jnainchi.InchiStereoParity;
import io.github.dan2097.jnainchi.InchiStereoType;

public class InchiStereo {
    public static final InchiAtom STEREO_IMPLICIT_H = new InchiAtom("H");
    private final InchiAtom[] atoms;
    private final InchiAtom centralAtom;
    private final InchiStereoType type;
    private final InchiStereoParity parity;

    InchiStereo(InchiAtom[] atoms, InchiAtom centralAtom, InchiStereoType type, InchiStereoParity parity) {
        if (atoms == null) {
            throw new IllegalArgumentException("atoms was null");
        }
        if (type == null) {
            throw new IllegalArgumentException("type was null");
        }
        if (parity == null) {
            throw new IllegalArgumentException("parity was null");
        }
        if (atoms.length != 4) {
            throw new IllegalArgumentException("Atoms array should be length 4");
        }
        for (int i = 0; i < atoms.length; ++i) {
            if (atoms[i] != null) continue;
            throw new IllegalArgumentException("Atom at index " + i + " was null, use STEREO_IMPLICIT_H for implicit hydrogen, and the atom with a lone pair for lone pairs");
        }
        if (type != InchiStereoType.DoubleBond && centralAtom == null) {
            throw new IllegalArgumentException("centralAtom was null");
        }
        this.atoms = atoms;
        this.centralAtom = centralAtom;
        this.type = type;
        this.parity = parity;
    }

    public static InchiStereo createTetrahedralStereo(InchiAtom centralAtom, InchiAtom atom1, InchiAtom atom2, InchiAtom atom3, InchiAtom atom4, InchiStereoParity parity) {
        return new InchiStereo(new InchiAtom[]{atom1, atom2, atom3, atom4}, centralAtom, InchiStereoType.Tetrahedral, parity);
    }

    public static InchiStereo createDoubleBondStereo(InchiAtom atom1, InchiAtom atom2, InchiAtom atom3, InchiAtom atom4, InchiStereoParity parity) {
        if (STEREO_IMPLICIT_H == atom1 || STEREO_IMPLICIT_H == atom2 || STEREO_IMPLICIT_H == atom3 || STEREO_IMPLICIT_H == atom4) {
            throw new IllegalArgumentException("Double bond stereo should use non-implicit hydrogn atoms");
        }
        return new InchiStereo(new InchiAtom[]{atom1, atom2, atom3, atom4}, null, InchiStereoType.DoubleBond, parity);
    }

    public static InchiStereo createAllenalStereo(InchiAtom centralAtom, InchiAtom atom1, InchiAtom atom2, InchiAtom atom3, InchiAtom atom4, InchiStereoParity parity) {
        return new InchiStereo(new InchiAtom[]{atom1, atom2, atom3, atom4}, centralAtom, InchiStereoType.Allene, parity);
    }

    public InchiAtom[] getAtoms() {
        return this.atoms;
    }

    public InchiAtom getCentralAtom() {
        return this.centralAtom;
    }

    public InchiStereoType getType() {
        return this.type;
    }

    public InchiStereoParity getParity() {
        return this.parity;
    }
}

