/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.search;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.atomic.LongAdder;
import org.apache.lucene.index.LeafReaderContext;
import org.apache.lucene.search.Collector;
import org.apache.lucene.search.CollectorManager;
import org.apache.lucene.search.FilterScorable;
import org.apache.lucene.search.LeafCollector;
import org.apache.lucene.search.Scorable;
import org.apache.lucene.search.ScoreMode;
import org.apache.solr.search.EarlyTerminatingCollector;
import org.apache.solr.search.QueryCommand;

public class SolrMultiCollectorManager
implements CollectorManager<Collectors, Object[]> {
    private final CollectorManager<Collector, ?>[] collectorManagers;
    private LongAdder runningHits = null;
    private int maxDocsToCollect;
    private final List<Collectors> reducableCollectors = new ArrayList<Collectors>();

    @SafeVarargs
    public SolrMultiCollectorManager(QueryCommand queryCommand, CollectorManager<? extends Collector, ?> ... collectorManagers) {
        if (collectorManagers.length < 1) {
            throw new IllegalArgumentException("There must be at least one collector");
        }
        this.collectorManagers = collectorManagers;
        if (queryCommand.shouldEarlyTerminateSearch()) {
            this.runningHits = new LongAdder();
            this.maxDocsToCollect = queryCommand.getMaxHitsAllowed();
        }
    }

    public static ScoreMode scoreMode(Collector[] collectors) {
        ScoreMode scoreMode = null;
        for (Collector collector : collectors) {
            if (scoreMode == null) {
                scoreMode = collector.scoreMode();
                continue;
            }
            if (scoreMode == collector.scoreMode()) continue;
            return ScoreMode.COMPLETE;
        }
        return scoreMode;
    }

    public Collectors newCollector() throws IOException {
        Collectors collector = new Collectors();
        this.reducableCollectors.add(collector);
        return collector;
    }

    public Object[] reduce(Collection<Collectors> reducableCollectors) throws IOException {
        int size = reducableCollectors.size();
        Object[] results = new Object[this.collectorManagers.length];
        for (int i = 0; i < this.collectorManagers.length; ++i) {
            ArrayList<Collector> reducableCollector = new ArrayList<Collector>(size);
            for (Collectors collectors : reducableCollectors) {
                reducableCollector.add(collectors.collectors[i]);
            }
            results[i] = this.collectorManagers[i].reduce(reducableCollector);
        }
        return results;
    }

    public Object[] reduce() throws IOException {
        return this.reduce(this.reducableCollectors);
    }

    class Collectors
    implements Collector {
        private final Collector[] collectors;

        private Collectors() throws IOException {
            this.collectors = new Collector[SolrMultiCollectorManager.this.collectorManagers.length];
            for (int i = 0; i < this.collectors.length; ++i) {
                Object collector = SolrMultiCollectorManager.this.collectorManagers[i].newCollector();
                if (SolrMultiCollectorManager.this.runningHits != null) {
                    collector = new EarlyTerminatingCollector((Collector)collector, SolrMultiCollectorManager.this.maxDocsToCollect, SolrMultiCollectorManager.this.runningHits);
                }
                this.collectors[i] = collector;
            }
        }

        public final LeafCollector getLeafCollector(LeafReaderContext context) throws IOException {
            return new LeafCollectors(context, this.scoreMode() == ScoreMode.TOP_SCORES);
        }

        public final ScoreMode scoreMode() {
            return SolrMultiCollectorManager.scoreMode(this.collectors);
        }

        private class LeafCollectors
        implements LeafCollector {
            private final LeafCollector[] leafCollectors;
            private final boolean skipNonCompetitiveScores;

            private LeafCollectors(LeafReaderContext context, boolean skipNonCompetitiveScores) throws IOException {
                this.skipNonCompetitiveScores = skipNonCompetitiveScores;
                this.leafCollectors = new LeafCollector[Collectors.this.collectors.length];
                for (int i = 0; i < Collectors.this.collectors.length; ++i) {
                    this.leafCollectors[i] = Collectors.this.collectors[i].getLeafCollector(context);
                }
            }

            public final void setScorer(Scorable scorer) throws IOException {
                if (this.skipNonCompetitiveScores) {
                    for (LeafCollector leafCollector : this.leafCollectors) {
                        if (leafCollector == null) continue;
                        leafCollector.setScorer(scorer);
                    }
                } else {
                    FilterScorable fScorer = new FilterScorable(scorer){

                        public void setMinCompetitiveScore(float minScore) throws IOException {
                        }
                    };
                    for (LeafCollector leafCollector : this.leafCollectors) {
                        if (leafCollector == null) continue;
                        leafCollector.setScorer((Scorable)fScorer);
                    }
                }
            }

            public final void collect(int doc) throws IOException {
                for (LeafCollector leafCollector : this.leafCollectors) {
                    if (leafCollector == null) continue;
                    leafCollector.collect(doc);
                }
            }
        }
    }
}

