/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.codecs.simpletext;

import java.io.Closeable;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.apache.lucene.codecs.BufferingKnnVectorsWriter;
import org.apache.lucene.codecs.simpletext.SimpleTextUtil;
import org.apache.lucene.index.ByteVectorValues;
import org.apache.lucene.index.FieldInfo;
import org.apache.lucene.index.FloatVectorValues;
import org.apache.lucene.index.IndexFileNames;
import org.apache.lucene.index.SegmentWriteState;
import org.apache.lucene.store.DataOutput;
import org.apache.lucene.store.IndexOutput;
import org.apache.lucene.util.BytesRef;
import org.apache.lucene.util.BytesRefBuilder;
import org.apache.lucene.util.IOUtils;

public class SimpleTextKnnVectorsWriter
extends BufferingKnnVectorsWriter {
    static final BytesRef FIELD_NUMBER = new BytesRef((CharSequence)"field-number ");
    static final BytesRef FIELD_NAME = new BytesRef((CharSequence)"field-name ");
    static final BytesRef VECTOR_DATA_OFFSET = new BytesRef((CharSequence)"vector-data-offset ");
    static final BytesRef VECTOR_DATA_LENGTH = new BytesRef((CharSequence)"vector-data-length ");
    static final BytesRef VECTOR_DIMENSION = new BytesRef((CharSequence)"vector-dimension ");
    static final BytesRef SIZE = new BytesRef((CharSequence)"size ");
    private final IndexOutput meta;
    private final IndexOutput vectorData;
    private final BytesRefBuilder scratch = new BytesRefBuilder();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    SimpleTextKnnVectorsWriter(SegmentWriteState state) throws IOException {
        boolean success = false;
        try {
            String metaFileName = IndexFileNames.segmentFileName((String)state.segmentInfo.name, (String)state.segmentSuffix, (String)"gri");
            this.meta = state.directory.createOutput(metaFileName, state.context);
            String vectorDataFileName = IndexFileNames.segmentFileName((String)state.segmentInfo.name, (String)state.segmentSuffix, (String)"vec");
            this.vectorData = state.directory.createOutput(vectorDataFileName, state.context);
            return;
        }
        catch (Throwable throwable) {
            if (success) throw throwable;
            IOUtils.closeWhileHandlingException((Closeable[])new Closeable[]{this});
            throw throwable;
        }
    }

    public void writeField(FieldInfo fieldInfo, FloatVectorValues floatVectorValues, int maxDoc) throws IOException {
        long vectorDataOffset = this.vectorData.getFilePointer();
        ArrayList<Integer> docIds = new ArrayList<Integer>();
        int docV = floatVectorValues.nextDoc();
        while (docV != Integer.MAX_VALUE) {
            this.writeFloatVectorValue(floatVectorValues);
            docIds.add(docV);
            docV = floatVectorValues.nextDoc();
        }
        long vectorDataLength = this.vectorData.getFilePointer() - vectorDataOffset;
        this.writeMeta(fieldInfo, vectorDataOffset, vectorDataLength, docIds);
    }

    private void writeFloatVectorValue(FloatVectorValues vectors) throws IOException {
        float[] value = vectors.vectorValue();
        assert (value.length == vectors.dimension());
        this.write(this.vectorData, Arrays.toString(value));
        this.newline(this.vectorData);
    }

    public void writeField(FieldInfo fieldInfo, ByteVectorValues byteVectorValues, int maxDoc) throws IOException {
        long vectorDataOffset = this.vectorData.getFilePointer();
        ArrayList<Integer> docIds = new ArrayList<Integer>();
        int docV = byteVectorValues.nextDoc();
        while (docV != Integer.MAX_VALUE) {
            this.writeByteVectorValue(byteVectorValues);
            docIds.add(docV);
            docV = byteVectorValues.nextDoc();
        }
        long vectorDataLength = this.vectorData.getFilePointer() - vectorDataOffset;
        this.writeMeta(fieldInfo, vectorDataOffset, vectorDataLength, docIds);
    }

    private void writeByteVectorValue(ByteVectorValues vectors) throws IOException {
        byte[] value = vectors.vectorValue();
        assert (value.length == vectors.dimension());
        this.write(this.vectorData, Arrays.toString(value));
        this.newline(this.vectorData);
    }

    private void writeMeta(FieldInfo field, long vectorDataOffset, long vectorDataLength, List<Integer> docIds) throws IOException {
        this.writeField(this.meta, FIELD_NUMBER, field.number);
        this.writeField(this.meta, FIELD_NAME, field.name);
        this.writeField(this.meta, VECTOR_DATA_OFFSET, vectorDataOffset);
        this.writeField(this.meta, VECTOR_DATA_LENGTH, vectorDataLength);
        this.writeField(this.meta, VECTOR_DIMENSION, field.getVectorDimension());
        this.writeField(this.meta, SIZE, docIds.size());
        for (Integer docId : docIds) {
            this.writeInt(this.meta, docId);
            this.newline(this.meta);
        }
    }

    public void finish() throws IOException {
        this.writeField(this.meta, FIELD_NUMBER, -1);
        SimpleTextUtil.writeChecksum(this.meta, this.scratch);
        SimpleTextUtil.writeChecksum(this.vectorData, this.scratch);
    }

    public void close() throws IOException {
        IOUtils.close((Closeable[])new Closeable[]{this.vectorData, this.meta});
    }

    private void writeField(IndexOutput out, BytesRef fieldName, int value) throws IOException {
        this.write(out, fieldName);
        this.writeInt(out, value);
        this.newline(out);
    }

    private void writeField(IndexOutput out, BytesRef fieldName, long value) throws IOException {
        this.write(out, fieldName);
        this.writeLong(out, value);
        this.newline(out);
    }

    private void writeField(IndexOutput out, BytesRef fieldName, String value) throws IOException {
        this.write(out, fieldName);
        this.write(out, value);
        this.newline(out);
    }

    private void write(IndexOutput out, String s) throws IOException {
        SimpleTextUtil.write((DataOutput)out, s, this.scratch);
    }

    private void writeInt(IndexOutput out, int x) throws IOException {
        SimpleTextUtil.write((DataOutput)out, Integer.toString(x), this.scratch);
    }

    private void writeLong(IndexOutput out, long x) throws IOException {
        SimpleTextUtil.write((DataOutput)out, Long.toString(x), this.scratch);
    }

    private void write(IndexOutput out, BytesRef b) throws IOException {
        SimpleTextUtil.write((DataOutput)out, b);
    }

    private void newline(IndexOutput out) throws IOException {
        SimpleTextUtil.writeNewline((DataOutput)out);
    }
}

