/*
 * Decompiled with CFR 0.152.
 */
package thredds.catalog2.simpleImpl;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import thredds.catalog2.DatasetNode;
import thredds.catalog2.builder.BuilderException;
import thredds.catalog2.builder.BuilderIssues;
import thredds.catalog2.builder.DatasetNodeBuilder;
import thredds.catalog2.simpleImpl.DatasetNodeImpl;

class DatasetNodeContainer {
    private Logger log = LoggerFactory.getLogger(this.getClass());
    private List<DatasetNodeImpl> datasetNodeImplList = null;
    private List<String> localIdList;
    private final DatasetNodeContainer rootContainer;
    private Map<String, DatasetNodeImpl> datasetNodeImplMapByGloballyUniqueId;
    private boolean isBuilt = false;

    DatasetNodeContainer(DatasetNodeContainer rootContainer) {
        this.rootContainer = rootContainer;
    }

    DatasetNodeContainer getRootContainer() {
        if (this.rootContainer != null) {
            return this.rootContainer;
        }
        return this;
    }

    boolean isDatasetNodeIdInUseGlobally(String id) {
        return this.getDatasetNodeByGloballyUniqueId(id) != null;
    }

    boolean addDatasetNodeByGloballyUniqueId(DatasetNodeImpl datasetNode) {
        if (this.isBuilt) {
            throw new IllegalStateException("This DatasetNodeContainer has been built.");
        }
        if (datasetNode == null) {
            return false;
        }
        if (datasetNode.getId() == null) {
            return false;
        }
        if (this.rootContainer != null) {
            return this.rootContainer.addDatasetNodeByGloballyUniqueId(datasetNode);
        }
        if (this.datasetNodeImplMapByGloballyUniqueId == null) {
            this.datasetNodeImplMapByGloballyUniqueId = new HashMap<String, DatasetNodeImpl>();
        }
        if (this.datasetNodeImplMapByGloballyUniqueId.containsKey(datasetNode.getId())) {
            return false;
        }
        DatasetNodeImpl replacedDatasetNode = this.datasetNodeImplMapByGloballyUniqueId.put(datasetNode.getId(), datasetNode);
        if (replacedDatasetNode == null) {
            return true;
        }
        String msg = "DatasetNodeContainer in bad state [MapByGloballyUniqueId: containsKey(" + datasetNode.getId() + ")==false then put()!=null].";
        this.log.error("addDatasetNodeByGloballyUniqueId(): " + msg);
        throw new IllegalStateException(msg);
    }

    boolean removeDatasetNodeByGloballyUniqueId(String id) {
        if (this.isBuilt) {
            throw new IllegalStateException("This DatasetNodeContainer has been built.");
        }
        if (id == null) {
            return false;
        }
        if (this.rootContainer != null) {
            return this.rootContainer.removeDatasetNodeByGloballyUniqueId(id);
        }
        if (this.datasetNodeImplMapByGloballyUniqueId == null) {
            return false;
        }
        DatasetNodeImpl removedDatasetNode = this.datasetNodeImplMapByGloballyUniqueId.remove(id);
        return removedDatasetNode != null;
    }

    boolean addDatasetNodeToLocalById(DatasetNodeImpl datasetNode) {
        if (this.isBuilt) {
            throw new IllegalStateException("This DatasetNodeContainer has been built.");
        }
        if (datasetNode == null) {
            return false;
        }
        if (datasetNode.getId() == null) {
            return false;
        }
        if (this.localIdList == null) {
            this.localIdList = new ArrayList<String>();
        }
        return this.localIdList.add(datasetNode.getId());
    }

    boolean removeDatasetNodeFromLocalById(String id) {
        if (this.isBuilt) {
            throw new IllegalStateException("This DatasetNodeContainer has been built.");
        }
        if (id == null) {
            return false;
        }
        if (this.localIdList == null) {
            return false;
        }
        return this.localIdList.remove(id);
    }

    DatasetNodeImpl getDatasetNodeByGloballyUniqueId(String id) {
        if (id == null) {
            return null;
        }
        if (this.rootContainer != null) {
            return this.rootContainer.getDatasetNodeByGloballyUniqueId(id);
        }
        if (this.datasetNodeImplMapByGloballyUniqueId == null) {
            return null;
        }
        return this.datasetNodeImplMapByGloballyUniqueId.get(id);
    }

    boolean isEmpty() {
        if (this.datasetNodeImplList == null) {
            return true;
        }
        return this.datasetNodeImplList.isEmpty();
    }

    int size() {
        if (this.datasetNodeImplList == null) {
            return 0;
        }
        return this.datasetNodeImplList.size();
    }

    void addDatasetNode(DatasetNodeImpl datasetNode) {
        if (this.isBuilt) {
            throw new IllegalStateException("This DatasetNodeContainer has been built.");
        }
        if (datasetNode.getId() != null) {
            if (!this.addDatasetNodeByGloballyUniqueId(datasetNode)) {
                throw new IllegalStateException("Globally unique DatasetNode ID is already being used.");
            }
            if (this.localIdList == null) {
                this.localIdList = new ArrayList<String>();
            }
            this.localIdList.add(datasetNode.getId());
        }
        if (this.datasetNodeImplList == null) {
            this.datasetNodeImplList = new ArrayList<DatasetNodeImpl>();
        }
        if (!this.datasetNodeImplList.add(datasetNode)) {
            this.log.error("addDatasetNode(): failed to add datasetNode name [" + datasetNode.getName() + "].");
        }
    }

    boolean removeDatasetNode(DatasetNodeImpl datasetNode) {
        if (this.isBuilt) {
            throw new IllegalStateException("This DatasetNodeContainer has been built.");
        }
        if (datasetNode == null) {
            return false;
        }
        if (this.datasetNodeImplList == null) {
            return false;
        }
        if (!this.datasetNodeImplList.remove(datasetNode)) {
            return false;
        }
        String id = datasetNode.getId();
        if (id != null && this.localIdList != null && this.localIdList.remove(id) && !this.removeDatasetNodeByGloballyUniqueId(id)) {
            String msg = "Removal from DatasetNode by global ID inconsistent with DatasetNode removal [" + datasetNode.getName() + "].";
            this.log.error("removeDatasetNode(): " + msg);
            throw new IllegalStateException(msg);
        }
        return true;
    }

    List<DatasetNode> getDatasets() {
        if (!this.isBuilt) {
            throw new IllegalStateException("This DatasetNodeCollection has escaped its Builder before being built.");
        }
        if (this.datasetNodeImplList == null) {
            return Collections.emptyList();
        }
        return Collections.unmodifiableList(new ArrayList<DatasetNodeImpl>(this.datasetNodeImplList));
    }

    DatasetNode getDatasetById(String id) {
        if (!this.isBuilt) {
            throw new IllegalStateException("This DatasetNodeCollection has escaped its Builder before being built.");
        }
        if (id == null) {
            return null;
        }
        if (this.datasetNodeImplList == null) {
            return null;
        }
        if (this.localIdList != null && this.localIdList.contains(id)) {
            return this.getDatasetNodeByGloballyUniqueId(id);
        }
        return null;
    }

    List<DatasetNodeBuilder> getDatasetNodeBuilders() {
        if (this.isBuilt) {
            throw new IllegalStateException("This DatasetNodeContainer has been built.");
        }
        if (this.datasetNodeImplList == null) {
            return Collections.emptyList();
        }
        return Collections.unmodifiableList(new ArrayList<DatasetNodeImpl>(this.datasetNodeImplList));
    }

    DatasetNodeBuilder getDatasetNodeBuilderById(String id) {
        if (this.isBuilt) {
            throw new IllegalStateException("This DatasetNodeContainer has been built.");
        }
        if (id == null) {
            return null;
        }
        if (this.datasetNodeImplList == null) {
            return null;
        }
        if (this.localIdList != null && this.localIdList.contains(id)) {
            return this.getDatasetNodeByGloballyUniqueId(id);
        }
        return null;
    }

    BuilderIssues getIssues() {
        BuilderIssues issues = new BuilderIssues();
        if (this.datasetNodeImplList != null) {
            for (DatasetNodeBuilder datasetNodeBuilder : this.datasetNodeImplList) {
                issues.addAllIssues(datasetNodeBuilder.getIssues());
            }
        }
        return issues;
    }

    void build() throws BuilderException {
        if (this.isBuilt) {
            return;
        }
        if (this.datasetNodeImplList != null) {
            for (DatasetNodeBuilder datasetNodeBuilder : this.datasetNodeImplList) {
                datasetNodeBuilder.build();
            }
        }
        this.isBuilt = true;
    }
}

