/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.packagesearch.packageversionutils.normalization;

import java.lang.annotation.Annotation;
import java.util.Locale;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.CharRange;
import kotlin.reflect.KClass;
import kotlin.text.StringsKt;
import kotlinx.datetime.Instant;
import kotlinx.datetime.serializers.InstantIso8601Serializer;
import kotlinx.serialization.KSerializer;
import kotlinx.serialization.SealedClassSerializer;
import kotlinx.serialization.SerialName;
import kotlinx.serialization.Serializable;
import kotlinx.serialization.SerializationStrategy;
import kotlinx.serialization.descriptors.SerialDescriptor;
import kotlinx.serialization.encoding.CompositeEncoder;
import kotlinx.serialization.internal.PluginExceptionsKt;
import kotlinx.serialization.internal.SerializationConstructorMarker;
import kotlinx.serialization.internal.StringSerializer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.packagesearch.packageversionutils.PackageVersionUtils;
import org.jetbrains.packagesearch.packageversionutils.normalization.NormalizedVersion$Garbage$;
import org.jetbrains.packagesearch.packageversionutils.normalization.NormalizedVersion$Semantic$;
import org.jetbrains.packagesearch.packageversionutils.normalization.NormalizedVersion$TimestampLike$;
import org.jetbrains.packagesearch.packageversionutils.normalization.UtilsKt;
import org.jetbrains.packagesearch.packageversionutils.normalization.VersionComparatorUtil;

/*
 * Uses 'sealed' constructs - enablewith --sealed true
 */
@Serializable
@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0010\u000f\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\bw\u0018\u0000 \r2\b\u0012\u0004\u0012\u00020\u00000\u0001:\u0005\r\u000e\u000f\u0010\u0011R\u0012\u0010\u0002\u001a\u00020\u0003X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0004\u0010\u0005R\u0012\u0010\u0006\u001a\u00020\u0007X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0006\u0010\bR\u0014\u0010\t\u001a\u0004\u0018\u00010\nX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000b\u0010\f\u0082\u0001\u0003\u0012\u0013\u0014\u00a8\u0006\u0015"}, d2={"Lorg/jetbrains/packagesearch/packageversionutils/normalization/NormalizedVersion;", "", "versionName", "", "getVersionName", "()Ljava/lang/String;", "isStable", "", "()Z", "releasedAt", "Lkotlinx/datetime/Instant;", "getReleasedAt", "()Lkotlinx/datetime/Instant;", "Companion", "Semantic", "TimestampLike", "Garbage", "DecoratedVersion", "Lorg/jetbrains/packagesearch/packageversionutils/normalization/NormalizedVersion$Garbage;", "Lorg/jetbrains/packagesearch/packageversionutils/normalization/NormalizedVersion$Semantic;", "Lorg/jetbrains/packagesearch/packageversionutils/normalization/NormalizedVersion$TimestampLike;", "version-utils"})
public interface NormalizedVersion
extends Comparable<NormalizedVersion> {
    @NotNull
    public static final Companion Companion = org.jetbrains.packagesearch.packageversionutils.normalization.NormalizedVersion$Companion.$$INSTANCE;

    @NotNull
    public String getVersionName();

    public boolean isStable();

    @Nullable
    public Instant getReleasedAt();

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u001a\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\n\b\u0002\u0010\b\u001a\u0004\u0018\u00010\tJ\f\u0010\n\u001a\b\u0012\u0004\u0012\u00020\u00050\u000b\u00a8\u0006\f"}, d2={"Lorg/jetbrains/packagesearch/packageversionutils/normalization/NormalizedVersion$Companion;", "", "<init>", "()V", "from", "Lorg/jetbrains/packagesearch/packageversionutils/normalization/NormalizedVersion;", "versionName", "", "releasedAt", "Lkotlinx/datetime/Instant;", "serializer", "Lkotlinx/serialization/KSerializer;", "version-utils"})
    public static final class Companion {
        static final /* synthetic */ Companion $$INSTANCE;

        private Companion() {
        }

        @NotNull
        public final NormalizedVersion from(@NotNull String versionName, @Nullable Instant releasedAt) {
            Intrinsics.checkNotNullParameter((Object)versionName, (String)"versionName");
            return UtilsKt.normalizedVersion(versionName, PackageVersionUtils.evaluateStability$default(PackageVersionUtils.INSTANCE, versionName, null, 2, null), releasedAt, (Function0<Garbage>)((Function0)() -> Companion.from$lambda$0(versionName, releasedAt)));
        }

        public static /* synthetic */ NormalizedVersion from$default(Companion companion, String string, Instant instant, int n, Object object) {
            if ((n & 2) != 0) {
                instant = null;
            }
            return companion.from(string, instant);
        }

        @NotNull
        public final KSerializer<NormalizedVersion> serializer() {
            KClass[] kClassArray = new KClass[]{Reflection.getOrCreateKotlinClass(Garbage.class), Reflection.getOrCreateKotlinClass(Semantic.class), Reflection.getOrCreateKotlinClass(TimestampLike.class)};
            KClass[] kClassArray2 = kClassArray;
            kClassArray = new KSerializer[]{Garbage$$serializer.INSTANCE, Semantic$$serializer.INSTANCE, TimestampLike$$serializer.INSTANCE};
            return (KSerializer)new SealedClassSerializer("org.jetbrains.packagesearch.packageversionutils.normalization.NormalizedVersion", Reflection.getOrCreateKotlinClass(NormalizedVersion.class), kClassArray2, (KSerializer[])kClassArray, new Annotation[0]);
        }

        private static final Garbage from$lambda$0(String $versionName, Instant $releasedAt) {
            Intrinsics.checkNotNullParameter((Object)$versionName, (String)"$versionName");
            return new Garbage($versionName, PackageVersionUtils.evaluateStability$default(PackageVersionUtils.INSTANCE, $versionName, null, 2, null), $releasedAt);
        }

        static {
            $$INSTANCE = new Companion();
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0005\bf\u0018\u00002\u00020\u0001R\u0014\u0010\u0002\u001a\u0004\u0018\u00010\u0003X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0004\u0010\u0005R\u0014\u0010\u0006\u001a\u0004\u0018\u00010\u0003X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0007\u0010\u0005\u00a8\u0006\b"}, d2={"Lorg/jetbrains/packagesearch/packageversionutils/normalization/NormalizedVersion$DecoratedVersion;", "", "stabilityMarker", "", "getStabilityMarker", "()Ljava/lang/String;", "nonSemanticSuffix", "getNonSemanticSuffix", "version-utils"})
    public static interface DecoratedVersion {
        @Nullable
        public String getStabilityMarker();

        @Nullable
        public String getNonSemanticSuffix();
    }

    @Serializable
    @SerialName(value="garbage")
    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u000e\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0087\b\u0018\u0000 (2\u00020\u0001:\u0002'(B#\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\n\b\u0002\u0010\u0006\u001a\u0004\u0018\u00010\u0007\u00a2\u0006\u0004\b\b\u0010\tB7\b\u0010\u0012\u0006\u0010\n\u001a\u00020\u000b\u0012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\b\u0010\u0006\u001a\u0004\u0018\u00010\u0007\u0012\b\u0010\f\u001a\u0004\u0018\u00010\r\u00a2\u0006\u0004\b\b\u0010\u000eJ\u0011\u0010\u0014\u001a\u00020\u000b2\u0006\u0010\u0015\u001a\u00020\u0001H\u0096\u0002J\u0010\u0010\u0016\u001a\u00020\u000b2\u0006\u0010\u0015\u001a\u00020\u0000H\u0002J\t\u0010\u0017\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0018\u001a\u00020\u0005H\u00c6\u0003J\u000b\u0010\u0019\u001a\u0004\u0018\u00010\u0007H\u00c6\u0003J)\u0010\u001a\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00052\n\b\u0002\u0010\u0006\u001a\u0004\u0018\u00010\u0007H\u00c6\u0001J\u0013\u0010\u001b\u001a\u00020\u00052\b\u0010\u0015\u001a\u0004\u0018\u00010\u001cH\u00d6\u0003J\t\u0010\u001d\u001a\u00020\u000bH\u00d6\u0001J\t\u0010\u001e\u001a\u00020\u0003H\u00d6\u0001J%\u0010\u001f\u001a\u00020 2\u0006\u0010!\u001a\u00020\u00002\u0006\u0010\"\u001a\u00020#2\u0006\u0010$\u001a\u00020%H\u0001\u00a2\u0006\u0002\b&R\u0014\u0010\u0002\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u0014\u0010\u0004\u001a\u00020\u0005X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0004\u0010\u0011R\u0016\u0010\u0006\u001a\u0004\u0018\u00010\u0007X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013\u00a8\u0006)"}, d2={"Lorg/jetbrains/packagesearch/packageversionutils/normalization/NormalizedVersion$Garbage;", "Lorg/jetbrains/packagesearch/packageversionutils/normalization/NormalizedVersion;", "versionName", "", "isStable", "", "releasedAt", "Lkotlinx/datetime/Instant;", "<init>", "(Ljava/lang/String;ZLkotlinx/datetime/Instant;)V", "seen0", "", "serializationConstructorMarker", "Lkotlinx/serialization/internal/SerializationConstructorMarker;", "(ILjava/lang/String;ZLkotlinx/datetime/Instant;Lkotlinx/serialization/internal/SerializationConstructorMarker;)V", "getVersionName", "()Ljava/lang/String;", "()Z", "getReleasedAt", "()Lkotlinx/datetime/Instant;", "compareTo", "other", "compareByNameAndThenByTimestamp", "component1", "component2", "component3", "copy", "equals", "", "hashCode", "toString", "write$Self", "", "self", "output", "Lkotlinx/serialization/encoding/CompositeEncoder;", "serialDesc", "Lkotlinx/serialization/descriptors/SerialDescriptor;", "write$Self$version_utils", "$serializer", "Companion", "version-utils"})
    public static final class Garbage
    implements NormalizedVersion {
        @NotNull
        public static final Companion Companion = new Companion(null);
        @NotNull
        private final String versionName;
        private final boolean isStable;
        @Nullable
        private final Instant releasedAt;

        public Garbage(@NotNull String versionName, boolean isStable, @Nullable Instant releasedAt) {
            Intrinsics.checkNotNullParameter((Object)versionName, (String)"versionName");
            this.versionName = versionName;
            this.isStable = isStable;
            this.releasedAt = releasedAt;
        }

        public /* synthetic */ Garbage(String string, boolean bl, Instant instant, int n, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n & 4) != 0) {
                instant = null;
            }
            this(string, bl, instant);
        }

        @Override
        @NotNull
        public String getVersionName() {
            return this.versionName;
        }

        @Override
        public boolean isStable() {
            return this.isStable;
        }

        @Override
        @Nullable
        public Instant getReleasedAt() {
            return this.releasedAt;
        }

        @Override
        public int compareTo(@NotNull NormalizedVersion other) {
            int n;
            Intrinsics.checkNotNullParameter((Object)other, (String)"other");
            NormalizedVersion normalizedVersion = other;
            if (normalizedVersion instanceof Garbage) {
                n = this.compareByNameAndThenByTimestamp((Garbage)other);
            } else if (normalizedVersion instanceof Semantic || normalizedVersion instanceof TimestampLike) {
                n = -1;
            } else {
                throw new NoWhenBranchMatchedException();
            }
            return n;
        }

        private final int compareByNameAndThenByTimestamp(Garbage other) {
            int nameComparisonResult = VersionComparatorUtil.compare$default(VersionComparatorUtil.INSTANCE, this.getVersionName(), other.getVersionName(), null, 4, null);
            return nameComparisonResult == 0 ? UtilsKt.compareByTimestamp(this, other) : nameComparisonResult;
        }

        @NotNull
        public final String component1() {
            return this.versionName;
        }

        public final boolean component2() {
            return this.isStable;
        }

        @Nullable
        public final Instant component3() {
            return this.releasedAt;
        }

        @NotNull
        public final Garbage copy(@NotNull String versionName, boolean isStable, @Nullable Instant releasedAt) {
            Intrinsics.checkNotNullParameter((Object)versionName, (String)"versionName");
            return new Garbage(versionName, isStable, releasedAt);
        }

        public static /* synthetic */ Garbage copy$default(Garbage garbage, String string, boolean bl, Instant instant, int n, Object object) {
            if ((n & 1) != 0) {
                string = garbage.versionName;
            }
            if ((n & 2) != 0) {
                bl = garbage.isStable;
            }
            if ((n & 4) != 0) {
                instant = garbage.releasedAt;
            }
            return garbage.copy(string, bl, instant);
        }

        @NotNull
        public String toString() {
            return "Garbage(versionName=" + this.versionName + ", isStable=" + this.isStable + ", releasedAt=" + this.releasedAt + ")";
        }

        public int hashCode() {
            int result = this.versionName.hashCode();
            result = result * 31 + Boolean.hashCode(this.isStable);
            result = result * 31 + (this.releasedAt == null ? 0 : this.releasedAt.hashCode());
            return result;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof Garbage)) {
                return false;
            }
            Garbage garbage = (Garbage)other;
            if (!Intrinsics.areEqual((Object)this.versionName, (Object)garbage.versionName)) {
                return false;
            }
            if (this.isStable != garbage.isStable) {
                return false;
            }
            return Intrinsics.areEqual((Object)this.releasedAt, (Object)garbage.releasedAt);
        }

        @JvmStatic
        public static final /* synthetic */ void write$Self$version_utils(Garbage self, CompositeEncoder output, SerialDescriptor serialDesc) {
            output.encodeStringElement(serialDesc, 0, self.getVersionName());
            output.encodeBooleanElement(serialDesc, 1, self.isStable());
            if (output.shouldEncodeElementDefault(serialDesc, 2) ? true : self.getReleasedAt() != null) {
                output.encodeNullableSerializableElement(serialDesc, 2, (SerializationStrategy)InstantIso8601Serializer.INSTANCE, (Object)self.getReleasedAt());
            }
        }

        public /* synthetic */ Garbage(int seen0, String versionName, boolean isStable, Instant releasedAt, SerializationConstructorMarker serializationConstructorMarker) {
            if (3 != (3 & seen0)) {
                PluginExceptionsKt.throwMissingFieldException((int)seen0, (int)3, (SerialDescriptor)Garbage$$serializer.INSTANCE.getDescriptor());
            }
            this.versionName = versionName;
            this.isStable = isStable;
            this.releasedAt = (seen0 & 4) == 0 ? null : releasedAt;
        }

        @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0016\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a8\u0006\u0007"}, d2={"Lorg/jetbrains/packagesearch/packageversionutils/normalization/NormalizedVersion$Garbage$Companion;", "", "<init>", "()V", "serializer", "Lkotlinx/serialization/KSerializer;", "Lorg/jetbrains/packagesearch/packageversionutils/normalization/NormalizedVersion$Garbage;", "version-utils"})
        public static final class Companion {
            private Companion() {
            }

            @NotNull
            public final KSerializer<Garbage> serializer() {
                return (KSerializer)Garbage$$serializer.INSTANCE;
            }

            public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
                this();
            }
        }
    }

    @Serializable
    @SerialName(value="semantic")
    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000N\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0017\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0087\b\u0018\u0000 42\u00020\u00012\u00020\u0002:\u000245BC\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\n\b\u0002\u0010\u0007\u001a\u0004\u0018\u00010\b\u0012\u0006\u0010\t\u001a\u00020\u0004\u0012\n\b\u0002\u0010\n\u001a\u0004\u0018\u00010\u0004\u0012\n\b\u0002\u0010\u000b\u001a\u0004\u0018\u00010\u0004\u00a2\u0006\u0004\b\f\u0010\rBU\b\u0010\u0012\u0006\u0010\u000e\u001a\u00020\u000f\u0012\b\u0010\u0003\u001a\u0004\u0018\u00010\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\b\u0010\u0007\u001a\u0004\u0018\u00010\b\u0012\b\u0010\t\u001a\u0004\u0018\u00010\u0004\u0012\b\u0010\n\u001a\u0004\u0018\u00010\u0004\u0012\b\u0010\u000b\u001a\u0004\u0018\u00010\u0004\u0012\b\u0010\u0010\u001a\u0004\u0018\u00010\u0011\u00a2\u0006\u0004\b\f\u0010\u0012J\u0011\u0010\u001d\u001a\u00020\u000f2\u0006\u0010\u001e\u001a\u00020\u0001H\u0096\u0002J\u0010\u0010\u001f\u001a\u00020\u000f2\u0006\u0010\u001e\u001a\u00020\u0000H\u0002J\u0012\u0010 \u001a\u00020\u00062\b\u0010\u000b\u001a\u0004\u0018\u00010\u0004H\u0002J\t\u0010!\u001a\u00020\u0004H\u00c6\u0003J\t\u0010\"\u001a\u00020\u0006H\u00c6\u0003J\u000b\u0010#\u001a\u0004\u0018\u00010\bH\u00c6\u0003J\t\u0010$\u001a\u00020\u0004H\u00c6\u0003J\u000b\u0010%\u001a\u0004\u0018\u00010\u0004H\u00c6\u0003J\u000b\u0010&\u001a\u0004\u0018\u00010\u0004H\u00c6\u0003JK\u0010'\u001a\u00020\u00002\b\b\u0002\u0010\u0003\u001a\u00020\u00042\b\b\u0002\u0010\u0005\u001a\u00020\u00062\n\b\u0002\u0010\u0007\u001a\u0004\u0018\u00010\b2\b\b\u0002\u0010\t\u001a\u00020\u00042\n\b\u0002\u0010\n\u001a\u0004\u0018\u00010\u00042\n\b\u0002\u0010\u000b\u001a\u0004\u0018\u00010\u0004H\u00c6\u0001J\u0013\u0010(\u001a\u00020\u00062\b\u0010\u001e\u001a\u0004\u0018\u00010)H\u00d6\u0003J\t\u0010*\u001a\u00020\u000fH\u00d6\u0001J\t\u0010+\u001a\u00020\u0004H\u00d6\u0001J%\u0010,\u001a\u00020-2\u0006\u0010.\u001a\u00020\u00002\u0006\u0010/\u001a\u0002002\u0006\u00101\u001a\u000202H\u0001\u00a2\u0006\u0002\b3R\u0014\u0010\u0003\u001a\u00020\u0004X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0014R\u0014\u0010\u0005\u001a\u00020\u0006X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0015R\u0016\u0010\u0007\u001a\u0004\u0018\u00010\bX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u0017R\u0011\u0010\t\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0018\u0010\u0014R\u0016\u0010\n\u001a\u0004\u0018\u00010\u0004X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0019\u0010\u0014R\u0016\u0010\u000b\u001a\u0004\u0018\u00010\u0004X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001a\u0010\u0014R\u0011\u0010\u001b\u001a\u00020\u00048F\u00a2\u0006\u0006\u001a\u0004\b\u001c\u0010\u0014\u00a8\u00066"}, d2={"Lorg/jetbrains/packagesearch/packageversionutils/normalization/NormalizedVersion$Semantic;", "Lorg/jetbrains/packagesearch/packageversionutils/normalization/NormalizedVersion;", "Lorg/jetbrains/packagesearch/packageversionutils/normalization/NormalizedVersion$DecoratedVersion;", "versionName", "", "isStable", "", "releasedAt", "Lkotlinx/datetime/Instant;", "semanticPart", "stabilityMarker", "nonSemanticSuffix", "<init>", "(Ljava/lang/String;ZLkotlinx/datetime/Instant;Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;)V", "seen0", "", "serializationConstructorMarker", "Lkotlinx/serialization/internal/SerializationConstructorMarker;", "(ILjava/lang/String;ZLkotlinx/datetime/Instant;Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;Lkotlinx/serialization/internal/SerializationConstructorMarker;)V", "getVersionName", "()Ljava/lang/String;", "()Z", "getReleasedAt", "()Lkotlinx/datetime/Instant;", "getSemanticPart", "getStabilityMarker", "getNonSemanticSuffix", "semanticPartWithStabilityMarker", "getSemanticPartWithStabilityMarker", "compareTo", "other", "compareByNameAndThenByTimestamp", "canBeUsedForComparison", "component1", "component2", "component3", "component4", "component5", "component6", "copy", "equals", "", "hashCode", "toString", "write$Self", "", "self", "output", "Lkotlinx/serialization/encoding/CompositeEncoder;", "serialDesc", "Lkotlinx/serialization/descriptors/SerialDescriptor;", "write$Self$version_utils", "Companion", "$serializer", "version-utils"})
    @SourceDebugExtension(value={"SMAP\nNormalizedVersion.kt\nKotlin\n*S Kotlin\n*F\n+ 1 NormalizedVersion.kt\norg/jetbrains/packagesearch/packageversionutils/normalization/NormalizedVersion$Semantic\n+ 2 _Strings.kt\nkotlin/text/StringsKt___StringsKt\n*L\n1#1,152:1\n1069#2,2:153\n*S KotlinDebug\n*F\n+ 1 NormalizedVersion.kt\norg/jetbrains/packagesearch/packageversionutils/normalization/NormalizedVersion$Semantic\n*L\n81#1:153,2\n*E\n"})
    public static final class Semantic
    implements NormalizedVersion,
    DecoratedVersion {
        @NotNull
        public static final Companion Companion = new Companion(null);
        @NotNull
        private final String versionName;
        private final boolean isStable;
        @Nullable
        private final Instant releasedAt;
        @NotNull
        private final String semanticPart;
        @Nullable
        private final String stabilityMarker;
        @Nullable
        private final String nonSemanticSuffix;
        @NotNull
        private static final CharRange HEX_CHARS = new CharRange('a', 'f');

        public Semantic(@NotNull String versionName, boolean isStable, @Nullable Instant releasedAt, @NotNull String semanticPart, @Nullable String stabilityMarker, @Nullable String nonSemanticSuffix) {
            Intrinsics.checkNotNullParameter((Object)versionName, (String)"versionName");
            Intrinsics.checkNotNullParameter((Object)semanticPart, (String)"semanticPart");
            this.versionName = versionName;
            this.isStable = isStable;
            this.releasedAt = releasedAt;
            this.semanticPart = semanticPart;
            this.stabilityMarker = stabilityMarker;
            this.nonSemanticSuffix = nonSemanticSuffix;
        }

        public /* synthetic */ Semantic(String string, boolean bl, Instant instant, String string2, String string3, String string4, int n, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n & 4) != 0) {
                instant = null;
            }
            if ((n & 0x10) != 0) {
                string3 = null;
            }
            if ((n & 0x20) != 0) {
                string4 = null;
            }
            this(string, bl, instant, string2, string3, string4);
        }

        @Override
        @NotNull
        public String getVersionName() {
            return this.versionName;
        }

        @Override
        public boolean isStable() {
            return this.isStable;
        }

        @Override
        @Nullable
        public Instant getReleasedAt() {
            return this.releasedAt;
        }

        @NotNull
        public final String getSemanticPart() {
            return this.semanticPart;
        }

        @Override
        @Nullable
        public String getStabilityMarker() {
            return this.stabilityMarker;
        }

        @Override
        @Nullable
        public String getNonSemanticSuffix() {
            return this.nonSemanticSuffix;
        }

        @NotNull
        public final String getSemanticPartWithStabilityMarker() {
            String string = this.getStabilityMarker();
            if (string == null) {
                string = "";
            }
            return this.semanticPart + string;
        }

        @Override
        public int compareTo(@NotNull NormalizedVersion other) {
            int n;
            Intrinsics.checkNotNullParameter((Object)other, (String)"other");
            NormalizedVersion normalizedVersion = other;
            if (normalizedVersion instanceof Semantic) {
                n = this.compareByNameAndThenByTimestamp((Semantic)other);
            } else if (normalizedVersion instanceof TimestampLike || normalizedVersion instanceof Garbage) {
                n = 1;
            } else {
                throw new NoWhenBranchMatchedException();
            }
            return n;
        }

        private final int compareByNameAndThenByTimestamp(Semantic other) {
            int comparisonResult;
            int nameComparisonResult = VersionComparatorUtil.compare$default(VersionComparatorUtil.INSTANCE, this.getSemanticPartWithStabilityMarker(), other.getSemanticPartWithStabilityMarker(), null, 4, null);
            if (nameComparisonResult != 0) {
                return nameComparisonResult;
            }
            CharSequence charSequence = this.getNonSemanticSuffix();
            if ((charSequence == null || StringsKt.isBlank((CharSequence)charSequence)) && !((charSequence = (CharSequence)other.getNonSemanticSuffix()) == null || StringsKt.isBlank((CharSequence)charSequence))) {
                return -1;
            }
            charSequence = this.getNonSemanticSuffix();
            if (!(charSequence == null || StringsKt.isBlank((CharSequence)charSequence)) && ((charSequence = (CharSequence)other.getNonSemanticSuffix()) == null || StringsKt.isBlank((CharSequence)charSequence))) {
                return 1;
            }
            if (this.canBeUsedForComparison(this.getNonSemanticSuffix()) && this.canBeUsedForComparison(other.getNonSemanticSuffix()) && (comparisonResult = VersionComparatorUtil.compare$default(VersionComparatorUtil.INSTANCE, this.getVersionName(), other.getVersionName(), null, 4, null)) != 0) {
                return comparisonResult;
            }
            return 0;
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        private final boolean canBeUsedForComparison(String nonSemanticSuffix) {
            CharSequence charSequence = nonSemanticSuffix;
            if (charSequence == null) return false;
            if (StringsKt.isBlank((CharSequence)charSequence)) {
                return false;
            }
            boolean bl = false;
            if (bl) {
                return false;
            }
            String string = ((Object)StringsKt.trim((CharSequence)nonSemanticSuffix)).toString().toLowerCase(Locale.ROOT);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toLowerCase(...)");
            String normalizedSuffix = string;
            int n = normalizedSuffix.length();
            if (!(7 <= n ? n < 11 : false)) {
                if (normalizedSuffix.length() != 40) return true;
            }
            boolean bl2 = true;
            boolean hasGitHashLength = bl2;
            if (!hasGitHashLength) return true;
            CharSequence $this$all$iv = normalizedSuffix;
            boolean $i$f$all = false;
            int n2 = 0;
            while (n2 < $this$all$iv.length()) {
                char element$iv;
                char it = element$iv = $this$all$iv.charAt(n2);
                boolean bl3 = false;
                if (!Character.isDigit(it)) {
                    CharRange charRange = HEX_CHARS;
                    char c = charRange.getFirst();
                    if (!(it <= charRange.getLast() ? c <= it : false)) {
                        if (Character.isLetter(it)) return true;
                    }
                }
                boolean bl4 = true;
                if (!bl4) {
                    return true;
                }
                ++n2;
            }
            return false;
        }

        @NotNull
        public final String component1() {
            return this.versionName;
        }

        public final boolean component2() {
            return this.isStable;
        }

        @Nullable
        public final Instant component3() {
            return this.releasedAt;
        }

        @NotNull
        public final String component4() {
            return this.semanticPart;
        }

        @Nullable
        public final String component5() {
            return this.stabilityMarker;
        }

        @Nullable
        public final String component6() {
            return this.nonSemanticSuffix;
        }

        @NotNull
        public final Semantic copy(@NotNull String versionName, boolean isStable, @Nullable Instant releasedAt, @NotNull String semanticPart, @Nullable String stabilityMarker, @Nullable String nonSemanticSuffix) {
            Intrinsics.checkNotNullParameter((Object)versionName, (String)"versionName");
            Intrinsics.checkNotNullParameter((Object)semanticPart, (String)"semanticPart");
            return new Semantic(versionName, isStable, releasedAt, semanticPart, stabilityMarker, nonSemanticSuffix);
        }

        public static /* synthetic */ Semantic copy$default(Semantic semantic, String string, boolean bl, Instant instant, String string2, String string3, String string4, int n, Object object) {
            if ((n & 1) != 0) {
                string = semantic.versionName;
            }
            if ((n & 2) != 0) {
                bl = semantic.isStable;
            }
            if ((n & 4) != 0) {
                instant = semantic.releasedAt;
            }
            if ((n & 8) != 0) {
                string2 = semantic.semanticPart;
            }
            if ((n & 0x10) != 0) {
                string3 = semantic.stabilityMarker;
            }
            if ((n & 0x20) != 0) {
                string4 = semantic.nonSemanticSuffix;
            }
            return semantic.copy(string, bl, instant, string2, string3, string4);
        }

        @NotNull
        public String toString() {
            return "Semantic(versionName=" + this.versionName + ", isStable=" + this.isStable + ", releasedAt=" + this.releasedAt + ", semanticPart=" + this.semanticPart + ", stabilityMarker=" + this.stabilityMarker + ", nonSemanticSuffix=" + this.nonSemanticSuffix + ")";
        }

        public int hashCode() {
            int result = this.versionName.hashCode();
            result = result * 31 + Boolean.hashCode(this.isStable);
            result = result * 31 + (this.releasedAt == null ? 0 : this.releasedAt.hashCode());
            result = result * 31 + this.semanticPart.hashCode();
            result = result * 31 + (this.stabilityMarker == null ? 0 : this.stabilityMarker.hashCode());
            result = result * 31 + (this.nonSemanticSuffix == null ? 0 : this.nonSemanticSuffix.hashCode());
            return result;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof Semantic)) {
                return false;
            }
            Semantic semantic = (Semantic)other;
            if (!Intrinsics.areEqual((Object)this.versionName, (Object)semantic.versionName)) {
                return false;
            }
            if (this.isStable != semantic.isStable) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.releasedAt, (Object)semantic.releasedAt)) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.semanticPart, (Object)semantic.semanticPart)) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.stabilityMarker, (Object)semantic.stabilityMarker)) {
                return false;
            }
            return Intrinsics.areEqual((Object)this.nonSemanticSuffix, (Object)semantic.nonSemanticSuffix);
        }

        @JvmStatic
        public static final /* synthetic */ void write$Self$version_utils(Semantic self, CompositeEncoder output, SerialDescriptor serialDesc) {
            output.encodeStringElement(serialDesc, 0, self.getVersionName());
            output.encodeBooleanElement(serialDesc, 1, self.isStable());
            if (output.shouldEncodeElementDefault(serialDesc, 2) ? true : self.getReleasedAt() != null) {
                output.encodeNullableSerializableElement(serialDesc, 2, (SerializationStrategy)InstantIso8601Serializer.INSTANCE, (Object)self.getReleasedAt());
            }
            output.encodeStringElement(serialDesc, 3, self.semanticPart);
            if (output.shouldEncodeElementDefault(serialDesc, 4) ? true : self.getStabilityMarker() != null) {
                output.encodeNullableSerializableElement(serialDesc, 4, (SerializationStrategy)StringSerializer.INSTANCE, (Object)self.getStabilityMarker());
            }
            if (output.shouldEncodeElementDefault(serialDesc, 5) ? true : self.getNonSemanticSuffix() != null) {
                output.encodeNullableSerializableElement(serialDesc, 5, (SerializationStrategy)StringSerializer.INSTANCE, (Object)self.getNonSemanticSuffix());
            }
        }

        public /* synthetic */ Semantic(int seen0, String versionName, boolean isStable, Instant releasedAt, String semanticPart, String stabilityMarker, String nonSemanticSuffix, SerializationConstructorMarker serializationConstructorMarker) {
            if (11 != (0xB & seen0)) {
                PluginExceptionsKt.throwMissingFieldException((int)seen0, (int)11, (SerialDescriptor)Semantic$$serializer.INSTANCE.getDescriptor());
            }
            this.versionName = versionName;
            this.isStable = isStable;
            this.releasedAt = (seen0 & 4) == 0 ? null : releasedAt;
            this.semanticPart = semanticPart;
            this.stabilityMarker = (seen0 & 0x10) == 0 ? null : stabilityMarker;
            this.nonSemanticSuffix = (seen0 & 0x20) == 0 ? null : nonSemanticSuffix;
        }

        @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\t"}, d2={"Lorg/jetbrains/packagesearch/packageversionutils/normalization/NormalizedVersion$Semantic$Companion;", "", "<init>", "()V", "HEX_CHARS", "Lkotlin/ranges/CharRange;", "serializer", "Lkotlinx/serialization/KSerializer;", "Lorg/jetbrains/packagesearch/packageversionutils/normalization/NormalizedVersion$Semantic;", "version-utils"})
        public static final class Companion {
            private Companion() {
            }

            @NotNull
            public final KSerializer<Semantic> serializer() {
                return (KSerializer)Semantic$$serializer.INSTANCE;
            }

            public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
                this();
            }
        }
    }

    @Serializable
    @SerialName(value="timestamp-like")
    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000N\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0016\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0087\b\u0018\u0000 42\u00020\u00012\u00020\u0002:\u000234BC\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\n\b\u0002\u0010\u0007\u001a\u0004\u0018\u00010\b\u0012\u0006\u0010\t\u001a\u00020\u0004\u0012\n\b\u0002\u0010\n\u001a\u0004\u0018\u00010\u0004\u0012\n\b\u0002\u0010\u000b\u001a\u0004\u0018\u00010\u0004\u00a2\u0006\u0004\b\f\u0010\rBU\b\u0010\u0012\u0006\u0010\u000e\u001a\u00020\u000f\u0012\b\u0010\u0003\u001a\u0004\u0018\u00010\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\b\u0010\u0007\u001a\u0004\u0018\u00010\b\u0012\b\u0010\t\u001a\u0004\u0018\u00010\u0004\u0012\b\u0010\n\u001a\u0004\u0018\u00010\u0004\u0012\b\u0010\u000b\u001a\u0004\u0018\u00010\u0004\u0012\b\u0010\u0010\u001a\u0004\u0018\u00010\u0011\u00a2\u0006\u0004\b\f\u0010\u0012J\u0011\u0010\u001d\u001a\u00020\u000f2\u0006\u0010\u001e\u001a\u00020\u0001H\u0096\u0002J\u0010\u0010\u001f\u001a\u00020\u000f2\u0006\u0010\u001e\u001a\u00020\u0000H\u0002J\t\u0010 \u001a\u00020\u0004H\u00c6\u0003J\t\u0010!\u001a\u00020\u0006H\u00c6\u0003J\u000b\u0010\"\u001a\u0004\u0018\u00010\bH\u00c6\u0003J\t\u0010#\u001a\u00020\u0004H\u00c6\u0003J\u000b\u0010$\u001a\u0004\u0018\u00010\u0004H\u00c6\u0003J\u000b\u0010%\u001a\u0004\u0018\u00010\u0004H\u00c6\u0003JK\u0010&\u001a\u00020\u00002\b\b\u0002\u0010\u0003\u001a\u00020\u00042\b\b\u0002\u0010\u0005\u001a\u00020\u00062\n\b\u0002\u0010\u0007\u001a\u0004\u0018\u00010\b2\b\b\u0002\u0010\t\u001a\u00020\u00042\n\b\u0002\u0010\n\u001a\u0004\u0018\u00010\u00042\n\b\u0002\u0010\u000b\u001a\u0004\u0018\u00010\u0004H\u00c6\u0001J\u0013\u0010'\u001a\u00020\u00062\b\u0010\u001e\u001a\u0004\u0018\u00010(H\u00d6\u0003J\t\u0010)\u001a\u00020\u000fH\u00d6\u0001J\t\u0010*\u001a\u00020\u0004H\u00d6\u0001J%\u0010+\u001a\u00020,2\u0006\u0010-\u001a\u00020\u00002\u0006\u0010.\u001a\u00020/2\u0006\u00100\u001a\u000201H\u0001\u00a2\u0006\u0002\b2R\u0014\u0010\u0003\u001a\u00020\u0004X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0014R\u0014\u0010\u0005\u001a\u00020\u0006X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0015R\u0016\u0010\u0007\u001a\u0004\u0018\u00010\bX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u0017R\u0011\u0010\t\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0018\u0010\u0014R\u0016\u0010\n\u001a\u0004\u0018\u00010\u0004X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0019\u0010\u0014R\u0016\u0010\u000b\u001a\u0004\u0018\u00010\u0004X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001a\u0010\u0014R\u0014\u0010\u001b\u001a\u00020\u00048BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001c\u0010\u0014\u00a8\u00065"}, d2={"Lorg/jetbrains/packagesearch/packageversionutils/normalization/NormalizedVersion$TimestampLike;", "Lorg/jetbrains/packagesearch/packageversionutils/normalization/NormalizedVersion;", "Lorg/jetbrains/packagesearch/packageversionutils/normalization/NormalizedVersion$DecoratedVersion;", "versionName", "", "isStable", "", "releasedAt", "Lkotlinx/datetime/Instant;", "timestampPrefix", "stabilityMarker", "nonSemanticSuffix", "<init>", "(Ljava/lang/String;ZLkotlinx/datetime/Instant;Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;)V", "seen0", "", "serializationConstructorMarker", "Lkotlinx/serialization/internal/SerializationConstructorMarker;", "(ILjava/lang/String;ZLkotlinx/datetime/Instant;Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;Lkotlinx/serialization/internal/SerializationConstructorMarker;)V", "getVersionName", "()Ljava/lang/String;", "()Z", "getReleasedAt", "()Lkotlinx/datetime/Instant;", "getTimestampPrefix", "getStabilityMarker", "getNonSemanticSuffix", "timestampPrefixWithStabilityMarker", "getTimestampPrefixWithStabilityMarker", "compareTo", "other", "compareByNameAndThenByTimestamp", "component1", "component2", "component3", "component4", "component5", "component6", "copy", "equals", "", "hashCode", "toString", "write$Self", "", "self", "output", "Lkotlinx/serialization/encoding/CompositeEncoder;", "serialDesc", "Lkotlinx/serialization/descriptors/SerialDescriptor;", "write$Self$version_utils", "$serializer", "Companion", "version-utils"})
    public static final class TimestampLike
    implements NormalizedVersion,
    DecoratedVersion {
        @NotNull
        public static final Companion Companion = new Companion(null);
        @NotNull
        private final String versionName;
        private final boolean isStable;
        @Nullable
        private final Instant releasedAt;
        @NotNull
        private final String timestampPrefix;
        @Nullable
        private final String stabilityMarker;
        @Nullable
        private final String nonSemanticSuffix;

        public TimestampLike(@NotNull String versionName, boolean isStable, @Nullable Instant releasedAt, @NotNull String timestampPrefix, @Nullable String stabilityMarker, @Nullable String nonSemanticSuffix) {
            Intrinsics.checkNotNullParameter((Object)versionName, (String)"versionName");
            Intrinsics.checkNotNullParameter((Object)timestampPrefix, (String)"timestampPrefix");
            this.versionName = versionName;
            this.isStable = isStable;
            this.releasedAt = releasedAt;
            this.timestampPrefix = timestampPrefix;
            this.stabilityMarker = stabilityMarker;
            this.nonSemanticSuffix = nonSemanticSuffix;
        }

        public /* synthetic */ TimestampLike(String string, boolean bl, Instant instant, String string2, String string3, String string4, int n, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n & 4) != 0) {
                instant = null;
            }
            if ((n & 0x10) != 0) {
                string3 = null;
            }
            if ((n & 0x20) != 0) {
                string4 = null;
            }
            this(string, bl, instant, string2, string3, string4);
        }

        @Override
        @NotNull
        public String getVersionName() {
            return this.versionName;
        }

        @Override
        public boolean isStable() {
            return this.isStable;
        }

        @Override
        @Nullable
        public Instant getReleasedAt() {
            return this.releasedAt;
        }

        @NotNull
        public final String getTimestampPrefix() {
            return this.timestampPrefix;
        }

        @Override
        @Nullable
        public String getStabilityMarker() {
            return this.stabilityMarker;
        }

        @Override
        @Nullable
        public String getNonSemanticSuffix() {
            return this.nonSemanticSuffix;
        }

        private final String getTimestampPrefixWithStabilityMarker() {
            String string = this.getStabilityMarker();
            if (string == null) {
                string = "";
            }
            return this.timestampPrefix + string;
        }

        @Override
        public int compareTo(@NotNull NormalizedVersion other) {
            int n;
            Intrinsics.checkNotNullParameter((Object)other, (String)"other");
            NormalizedVersion normalizedVersion = other;
            if (normalizedVersion instanceof TimestampLike) {
                n = this.compareByNameAndThenByTimestamp((TimestampLike)other);
            } else if (normalizedVersion instanceof Semantic) {
                n = -1;
            } else if (normalizedVersion instanceof Garbage) {
                n = 1;
            } else {
                throw new NoWhenBranchMatchedException();
            }
            return n;
        }

        private final int compareByNameAndThenByTimestamp(TimestampLike other) {
            int nameComparisonResult = VersionComparatorUtil.compare$default(VersionComparatorUtil.INSTANCE, this.getTimestampPrefixWithStabilityMarker(), other.getTimestampPrefixWithStabilityMarker(), null, 4, null);
            return nameComparisonResult == 0 ? UtilsKt.compareByTimestamp(this, other) : nameComparisonResult;
        }

        @NotNull
        public final String component1() {
            return this.versionName;
        }

        public final boolean component2() {
            return this.isStable;
        }

        @Nullable
        public final Instant component3() {
            return this.releasedAt;
        }

        @NotNull
        public final String component4() {
            return this.timestampPrefix;
        }

        @Nullable
        public final String component5() {
            return this.stabilityMarker;
        }

        @Nullable
        public final String component6() {
            return this.nonSemanticSuffix;
        }

        @NotNull
        public final TimestampLike copy(@NotNull String versionName, boolean isStable, @Nullable Instant releasedAt, @NotNull String timestampPrefix, @Nullable String stabilityMarker, @Nullable String nonSemanticSuffix) {
            Intrinsics.checkNotNullParameter((Object)versionName, (String)"versionName");
            Intrinsics.checkNotNullParameter((Object)timestampPrefix, (String)"timestampPrefix");
            return new TimestampLike(versionName, isStable, releasedAt, timestampPrefix, stabilityMarker, nonSemanticSuffix);
        }

        public static /* synthetic */ TimestampLike copy$default(TimestampLike timestampLike, String string, boolean bl, Instant instant, String string2, String string3, String string4, int n, Object object) {
            if ((n & 1) != 0) {
                string = timestampLike.versionName;
            }
            if ((n & 2) != 0) {
                bl = timestampLike.isStable;
            }
            if ((n & 4) != 0) {
                instant = timestampLike.releasedAt;
            }
            if ((n & 8) != 0) {
                string2 = timestampLike.timestampPrefix;
            }
            if ((n & 0x10) != 0) {
                string3 = timestampLike.stabilityMarker;
            }
            if ((n & 0x20) != 0) {
                string4 = timestampLike.nonSemanticSuffix;
            }
            return timestampLike.copy(string, bl, instant, string2, string3, string4);
        }

        @NotNull
        public String toString() {
            return "TimestampLike(versionName=" + this.versionName + ", isStable=" + this.isStable + ", releasedAt=" + this.releasedAt + ", timestampPrefix=" + this.timestampPrefix + ", stabilityMarker=" + this.stabilityMarker + ", nonSemanticSuffix=" + this.nonSemanticSuffix + ")";
        }

        public int hashCode() {
            int result = this.versionName.hashCode();
            result = result * 31 + Boolean.hashCode(this.isStable);
            result = result * 31 + (this.releasedAt == null ? 0 : this.releasedAt.hashCode());
            result = result * 31 + this.timestampPrefix.hashCode();
            result = result * 31 + (this.stabilityMarker == null ? 0 : this.stabilityMarker.hashCode());
            result = result * 31 + (this.nonSemanticSuffix == null ? 0 : this.nonSemanticSuffix.hashCode());
            return result;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof TimestampLike)) {
                return false;
            }
            TimestampLike timestampLike = (TimestampLike)other;
            if (!Intrinsics.areEqual((Object)this.versionName, (Object)timestampLike.versionName)) {
                return false;
            }
            if (this.isStable != timestampLike.isStable) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.releasedAt, (Object)timestampLike.releasedAt)) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.timestampPrefix, (Object)timestampLike.timestampPrefix)) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.stabilityMarker, (Object)timestampLike.stabilityMarker)) {
                return false;
            }
            return Intrinsics.areEqual((Object)this.nonSemanticSuffix, (Object)timestampLike.nonSemanticSuffix);
        }

        @JvmStatic
        public static final /* synthetic */ void write$Self$version_utils(TimestampLike self, CompositeEncoder output, SerialDescriptor serialDesc) {
            output.encodeStringElement(serialDesc, 0, self.getVersionName());
            output.encodeBooleanElement(serialDesc, 1, self.isStable());
            if (output.shouldEncodeElementDefault(serialDesc, 2) ? true : self.getReleasedAt() != null) {
                output.encodeNullableSerializableElement(serialDesc, 2, (SerializationStrategy)InstantIso8601Serializer.INSTANCE, (Object)self.getReleasedAt());
            }
            output.encodeStringElement(serialDesc, 3, self.timestampPrefix);
            if (output.shouldEncodeElementDefault(serialDesc, 4) ? true : self.getStabilityMarker() != null) {
                output.encodeNullableSerializableElement(serialDesc, 4, (SerializationStrategy)StringSerializer.INSTANCE, (Object)self.getStabilityMarker());
            }
            if (output.shouldEncodeElementDefault(serialDesc, 5) ? true : self.getNonSemanticSuffix() != null) {
                output.encodeNullableSerializableElement(serialDesc, 5, (SerializationStrategy)StringSerializer.INSTANCE, (Object)self.getNonSemanticSuffix());
            }
        }

        public /* synthetic */ TimestampLike(int seen0, String versionName, boolean isStable, Instant releasedAt, String timestampPrefix, String stabilityMarker, String nonSemanticSuffix, SerializationConstructorMarker serializationConstructorMarker) {
            if (11 != (0xB & seen0)) {
                PluginExceptionsKt.throwMissingFieldException((int)seen0, (int)11, (SerialDescriptor)TimestampLike$$serializer.INSTANCE.getDescriptor());
            }
            this.versionName = versionName;
            this.isStable = isStable;
            this.releasedAt = (seen0 & 4) == 0 ? null : releasedAt;
            this.timestampPrefix = timestampPrefix;
            this.stabilityMarker = (seen0 & 0x10) == 0 ? null : stabilityMarker;
            this.nonSemanticSuffix = (seen0 & 0x20) == 0 ? null : nonSemanticSuffix;
        }

        @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0016\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a8\u0006\u0007"}, d2={"Lorg/jetbrains/packagesearch/packageversionutils/normalization/NormalizedVersion$TimestampLike$Companion;", "", "<init>", "()V", "serializer", "Lkotlinx/serialization/KSerializer;", "Lorg/jetbrains/packagesearch/packageversionutils/normalization/NormalizedVersion$TimestampLike;", "version-utils"})
        public static final class Companion {
            private Companion() {
            }

            @NotNull
            public final KSerializer<TimestampLike> serializer() {
                return (KSerializer)TimestampLike$$serializer.INSTANCE;
            }

            public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
                this();
            }
        }
    }
}

