/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.coverage.report.impl.html;

import java.io.File;
import jetbrains.coverage.report.ClassInfo;
import jetbrains.coverage.report.impl.IOUtil;
import jetbrains.coverage.report.impl.html.GeneratorPaths;
import jetbrains.coverage.report.impl.html.LocalGeneratorPaths;
import jetbrains.coverage.report.impl.html.ModuleInfo;
import jetbrains.coverage.report.impl.html.SortOption;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class GeneratorPathsImpl
implements GeneratorPaths {
    private final LocalGeneratorPaths myPaths;
    private final File myGeneratingFile;
    private final File myGeneratingDir;

    public GeneratorPathsImpl(@NotNull LocalGeneratorPaths paths, @NotNull File generatingFile) {
        this.myGeneratingFile = generatingFile;
        this.myPaths = paths;
        this.myGeneratingDir = this.myGeneratingFile.getParentFile();
    }

    @NotNull
    private String makeRelative(@NotNull GeneratorPaths file) {
        return this.makeRelative(file.getReportFileName());
    }

    @NotNull
    private String makeRelative(@NotNull File file) {
        return IOUtil.makeRelative(this.myGeneratingDir.getAbsoluteFile(), file.getAbsoluteFile()).replace('\\', '/');
    }

    @NotNull
    public File getReportFileName() {
        return this.myGeneratingFile;
    }

    @NotNull
    public String getOrder(@NotNull SortOption order) {
        return order.getIndexFileName();
    }

    @NotNull
    public String getResourcesPath() {
        return this.makeRelative(this.myPaths.getResourcesPath());
    }

    @NotNull
    public String getModulesIndexPath(@NotNull SortOption order) {
        return this.makeRelative(this.myPaths.getModulesIndexPath(order));
    }

    @NotNull
    public String getNamespacesIndexPath(@NotNull ModuleInfo module, @NotNull SortOption order) {
        return this.makeRelative(this.myPaths.getNamespacesIndexPath(module, order));
    }

    @NotNull
    public String getClassesIndexPath(@NotNull ModuleInfo module, @Nullable String namespace, @NotNull SortOption order) {
        return this.makeRelative(this.myPaths.getClassesIndexPath(module, namespace, order));
    }

    @NotNull
    public String getClassCoveragePath(@NotNull ModuleInfo module, @Nullable String namespace, @NotNull ClassInfo clazz) {
        return this.makeRelative(this.myPaths.getClassCoveragePath(module, namespace, clazz));
    }
}

