# This file has been autogenerated by the pywayland scanner

# Copyright (C) 2015 Martin Gräßlin
# Copyright (C) 2015 Marco Martin
# Copyright (C) 2020 Vlad Zahorodnii
# Copyright (C) 2024 Xaver Hugl
#
# Permission is hereby granted, free of charge, to any person obtaining a
# copy of this software and associated documentation files (the "Software"),
# to deal in the Software without restriction, including without limitation
# the rights to use, copy, modify, merge, publish, distribute, sublicense,
# and/or sell copies of the Software, and to permit persons to whom the
# Software is furnished to do so, subject to the following conditions:
#
# The above copyright notice and this permission notice (including the next
# paragraph) shall be included in all copies or substantial portions of the
# Software.
#
# THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
# IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
# FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.  IN NO EVENT SHALL
# THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
# LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING
# FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER
# DEALINGS IN THE SOFTWARE.

from __future__ import annotations

import enum

from pywayland.protocol_core import (
    Argument,
    ArgumentType,
    Global,
    Interface,
    Proxy,
    Resource,
)

from ..wayland import WlSurface
from .ext_background_effect_surface_v1 import ExtBackgroundEffectSurfaceV1


class ExtBackgroundEffectManagerV1(Interface):
    """Background effect factory

    This protocol provides a way to improve visuals of translucent surfaces by
    applying effects like blur to the background behind them.

    The capabilities are send when the global is bound, and every time they
    change. Note that when the capability goes away, the corresponding effect
    is no longer applied by the compositor, even if it was set before.

    Warning! The protocol described in this file is currently in the testing
    phase. Backward compatible changes may be added together with the
    corresponding interface version bump. Backward incompatible changes can
    only be done by creating a new major version of the extension.
    """

    name = "ext_background_effect_manager_v1"
    version = 1

    class error(enum.IntEnum):
        background_effect_exists = 0

    class capability(enum.IntFlag):
        blur = 1


class ExtBackgroundEffectManagerV1Proxy(Proxy[ExtBackgroundEffectManagerV1]):
    interface = ExtBackgroundEffectManagerV1

    @ExtBackgroundEffectManagerV1.request()
    def destroy(self) -> None:
        """Destroy the background effect manager

        Informs the server that the client will no longer be using this
        protocol object. Existing objects created by this object are not
        affected.
        """
        self._marshal(0)
        self._destroy()

    @ExtBackgroundEffectManagerV1.request(
        Argument(ArgumentType.NewId, interface=ExtBackgroundEffectSurfaceV1),
        Argument(ArgumentType.Object, interface=WlSurface),
    )
    def get_background_effect(self, surface: WlSurface) -> Proxy[ExtBackgroundEffectSurfaceV1]:
        """Get a background effects object

        Instantiate an interface extension for the given
        :class:`~pywayland.protocol.wayland.WlSurface` to add effects like blur
        for the background behind it.

        If the given :class:`~pywayland.protocol.wayland.WlSurface` already has
        a
        :class:`~pywayland.protocol.ext_background_effect_v1.ExtBackgroundEffectSurfaceV1`
        object associated, the background_effect_exists protocol error will be
        raised.

        :param surface:
            the surface
        :type surface:
            :class:`~pywayland.protocol.wayland.WlSurface`
        :returns:
            :class:`~pywayland.protocol.ext_background_effect_v1.ExtBackgroundEffectSurfaceV1`
            -- the new
            :class:`~pywayland.protocol.ext_background_effect_v1.ExtBackgroundEffectSurfaceV1`
            object
        """
        id = self._marshal_constructor(1, ExtBackgroundEffectSurfaceV1, surface)
        return id


class ExtBackgroundEffectManagerV1Resource(Resource):
    interface = ExtBackgroundEffectManagerV1

    @ExtBackgroundEffectManagerV1.event(
        Argument(ArgumentType.Uint),
    )
    def capabilities(self, flags: int) -> None:
        """Capabilities of the compositor

        :param flags:
        :type flags:
            `ArgumentType.Uint`
        """
        self._post_event(0, flags)


class ExtBackgroundEffectManagerV1Global(Global):
    interface = ExtBackgroundEffectManagerV1


ExtBackgroundEffectManagerV1._gen_c()
ExtBackgroundEffectManagerV1.proxy_class = ExtBackgroundEffectManagerV1Proxy
ExtBackgroundEffectManagerV1.resource_class = ExtBackgroundEffectManagerV1Resource
ExtBackgroundEffectManagerV1.global_class = ExtBackgroundEffectManagerV1Global
